<p align="center"><a href="https://laravel.com" target="_blank"><img src="https://raw.githubusercontent.com/laravel/art/master/logo-lockup/5%20SVG/2%20CMYK/1%20Full%20Color/la## Kontribusi

Kami sangat menyambut kontribusi dari siapa saja. Untuk berkontribusi pada proyek ini:

1. Fork repositori ini
2. Buat branch fitur baru (`git checkout -b fitur-baru`)
3. Commit perubahan Anda (`git commit -m 'Menambahkan fitur baru'`)
4. Push ke branch yang dibuat (`git push origin fitur-baru`)
5. Buat Pull Request baru

## Pelaporan Bug

Jika Anda menemukan bug atau masalah pada aplikasi, silakan buat issue di repositori GitHub dengan langkah:
1. Jelaskan masalah dengan detail
2. Sertakan langkah-langkah untuk mereproduksi bug
3. Jelaskan apa yang Anda harapkan seharusnya terjadi
4. Sertakan tangkapan layar jika memungkinkan

## Keamanan

Jika Anda menemukan kerentanan keamanan dalam aplikasi, mohon kirimkan email ke alamat pengembang dan jangan publikasikan masalah tersebut secara terbuka sebelum diperbaiki.

## Lisensi

Aplikasi Lapor Mas Wapress dilisensikan di bawah [lisensi MIT](https://opensource.org/licenses/MIT).p-cmyk-red.svg" width="400" alt="Laravel Logo"></a></p>

# Lapor Mas Wapress

Aplikasi Lapor Mas Wapress adalah sistem berbasis web yang dibangun dengan framework Laravel untuk mengelola pendaftaran dan pelaporan dengan dukungan WhatsApp dan fitur-fitur lainnya.

## Daftar Isi
- [Persyaratan Sistem](#persyaratan-sistem)
- [Instalasi](#instalasi)
- [Konfigurasi](#konfigurasi)
- [Penggunaan](#penggunaan)
- [Fitur](#fitur)
- [Struktur Database](#struktur-database)
- [Kontribusi](#kontribusi)
- [Lisensi](#lisensi)

## Persyaratan Sistem

Sebelum melakukan instalasi, pastikan sistem Anda memenuhi persyaratan berikut:

- PHP >= 8.1
- Composer
- Node.js & NPM
- Database MySQL/MariaDB
- Ekstensi PHP: BCMath, Ctype, Fileinfo, JSON, Mbstring, OpenSSL, PDO, Tokenizer, XML
- Git

## Instalasi

Berikut adalah langkah-langkah untuk melakukan instalasi aplikasi Lapor Mas Wapress:

1. Clone repositori dari GitHub:
```bash
git clone https://github.com/username/lapor-mas-wapress.git
cd lapor-mas-wapress
```

2. Instal dependensi PHP menggunakan Composer:
```bash
composer install
```

3. Instal dependensi JavaScript menggunakan NPM:
```bash
npm install
```

4. Salin file `.env.example` menjadi `.env`:
```bash
cp .env.example .env
```

5. Generate key aplikasi:
```bash
php artisan key:generate
```

6. Konfigurasi database pada file `.env`:
```
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=lapormaswapres
DB_USERNAME=root
DB_PASSWORD=
```

7. Jalankan migrasi dan seeder untuk inisialisasi database:
```bash
php artisan migrate --seed
```

8. Jalankan perintah untuk mengompilasi aset:
```bash
npm run dev
```

9. Jalankan server lokal:
```bash
php artisan serve
```

10. Akses aplikasi melalui browser di alamat http://localhost:8000

### Instalasi Menggunakan Docker

Anda juga dapat menggunakan Docker untuk menjalankan aplikasi ini:

1. Pastikan Docker dan Docker Compose sudah terinstal di sistem Anda
2. Jalankan perintah berikut:
```bash
docker-compose up -d
```
3. Akses aplikasi melalui browser di alamat http://localhost:8000

## Konfigurasi

Beberapa konfigurasi yang perlu dilakukan setelah instalasi:

### Konfigurasi WhatsApp

Untuk mengaktifkan integrasi WhatsApp: 1. Konfigurasi pada file `.env`:

```
WAPRESS_API_KEY=api_key_anda
WAPRESS_PHONE_ID=phone_id_anda
WAPRESS_BASE_URL=https://api.wapress.io
```

2. Aktifkan webhook untuk notifikasi WhatsApp:

```bash
php artisan wapress:configure-webhook
```

### Konfigurasi Email

Untuk mengaktifkan notifikasi email:

```
MAIL_MAILER=smtp
MAIL_HOST=smtp.mailtrap.io
MAIL_PORT=2525
MAIL_USERNAME=username_anda
MAIL_PASSWORD=password_anda
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="noreply@lapormas.com"
MAIL_FROM_NAME="${APP_NAME}"
```

## Penggunaan

### Panel Admin

1. Akses panel admin melalui `/admin/login`
2. Login menggunakan kredensial admin default:
   - Email: admin@admin.com
   - Password: password

### Manajemen Pendaftaran

Untuk mengelola pendaftaran:
1. Buka menu "Pendaftaran" di panel admin
2. Anda dapat melihat, mengedit, menghapus, dan mengekspor data pendaftaran
3. Untuk mengatur kuota, buka menu "Pengaturan Kuota"

### Pengaturan Kuota dan Jadwal

Untuk mengatur kuota dan jadwal:
1. Buka menu "Pengaturan" > "Kuota & Jadwal"
2. Tetapkan jumlah kuota harian dan atur slot waktu yang tersedia

## Fitur

Aplikasi Lapor Mas Wapress memiliki beberapa fitur utama:

- Manajemen pendaftaran
- Notifikasi WhatsApp otomatis
- Pengaturan kuota dan slot waktu
- Panel admin untuk pengelolaan data
- Ekspor data ke format Excel/CSV
- Integrasi dengan API WhatsApp
- Konfigurasi hari libur

## Struktur Database

Proyek ini menggunakan beberapa tabel utama:

- `users`: Menyimpan data pengguna sistem
- `admins`: Menyimpan data admin sistem
- `registrations`: Menyimpan data pendaftaran
- `time_slots`: Menyimpan data slot waktu yang tersedia
- `quotas`: Menyimpan data kuota pendaftaran
- `holidays`: Menyimpan data hari libur

## Kontribusi

Thank you for considering contributing to the Laravel framework! The contribution guide can be found in the [Laravel documentation](https://laravel.com/docs/contributions).

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Laravel, please send an e-mail to Taylor Otwell via [taylor@laravel.com](mailto:taylor@laravel.com). All security vulnerabilities will be promptly addressed.

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
