<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Symfony\Component\HttpKernel\Exception\PostTooLargeException;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });

        // Custom handler for POST too large exception
        $this->renderable(function (PostTooLargeException $e, $request) {
            if ($request->is('register')) {
                return back()
                    ->withErrors(['ktp_image' => 'Ukuran file terlalu besar. Maksimal ukuran file adalah ' . ini_get('post_max_size') . '. Silakan kompres gambar Anda terlebih dahulu.'])
                    ->withInput();
            }
            
            return back()->withErrors([
                'message' => 'Ukuran data yang dikirim terlalu besar. Maksimal ukuran data adalah ' . ini_get('post_max_size') . '.'
            ]);
        });
    }
}
