<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Holiday extends Model
{
    protected $fillable = ['date', 'description', 'start_date', 'end_date'];
    
    // Cast date fields to Carbon instances
    protected $casts = [
        'date' => 'date',
        'start_date' => 'date',
        'end_date' => 'date'
    ];
    
    /**
     * Create a formatted date range string
     *
     * @return string
     */
    public function getDateRangeAttribute()
    {
        // If start_date and end_date are the same, return a single date
        if ($this->start_date && $this->end_date && $this->start_date->eq($this->end_date)) {
            return Carbon::parse($this->start_date)->format('d/m/Y');
        }
        
        // Otherwise, return a range
        if ($this->start_date && $this->end_date) {
            return Carbon::parse($this->start_date)->format('d/m/Y') . ' - ' . Carbon::parse($this->end_date)->format('d/m/Y');
        }
        
        // Fallback to the original date field for backward compatibility
        if ($this->date) {
            return Carbon::parse($this->date)->format('d/m/Y');
        }
        
        return '';
    }
}
