<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TimeSlot extends Model
{
    protected $table = 'time_slots';
    
    protected $fillable = [
        'time',
        'quota',
        'is_active',
        'label',
        'display_order'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'quota' => 'integer',
        'display_order' => 'integer'
    ];

    /**
     * Scope a query to only include active time slots.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Get all active time slots ordered by display_order
     */
    public static function getActiveSlots()
    {
        return self::active()
            ->orderBy('display_order')
            ->orderBy('time')
            ->get();
    }
}
