<?php

namespace Database\Factories;

use App\Models\Registration;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class RegistrationFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Registration::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->name(),
            'nik' => $this->faker->unique()->numerify('################'), // 16 digits NIK
            'kk_number' => $this->faker->unique()->numerify('################'), // 16 digits KK
            'gender' => $this->faker->randomElement(['Laki-laki', 'Perempuan']),
            'phone' => $this->faker->unique()->phoneNumber(),
            'email' => $this->faker->unique()->safeEmail(),
            'address' => $this->faker->address(),
            'registration_date' => $this->faker->dateTimeBetween('+1 day', '+1 month')->format('Y-m-d'),
            'status' => $this->faker->randomElement(['pending', 'approved', 'rejected']),
            'booking_code' => strtoupper(Str::random(8)),
        ];
    }
}
