<!-- resources/views/admin/dashboard.blade.php -->
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="{{ asset('css/styles.css') }}" rel="stylesheet">    <style>
        .tab-pane {
            padding: 15px 0;
        }
        .stat-card {
            transition: all 0.3s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }
        .table-responsive {
            max-height: 400px;
            overflow-y: auto;
        }
        .nav-tabs .nav-link {
            font-weight: 500;
        }
        .nav-tabs .nav-link.active {
            border-bottom: 3px solid #0d6efd;
        }
        /* Column width adjustments */
        .col-address {
            min-width: 200px;
            max-width: 250px;
            white-space: normal;
            word-wrap: break-word;
        }
        .col-name {
            min-width: 150px;
        }
        .col-topic {
            min-width: 180px;
        }
        .col-nik {
            min-width: 130px;
        }
        .col-phone {
            min-width: 120px;
        }
        /* Table cell styling */
        .table td {
            vertical-align: middle;
        }
    </style>
</head>
<body class="bg-light">
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary mb-3">
        <div class="container">
            <a class="navbar-brand" href="#">
                <img src="{{ asset('images/logo.png') }}" alt="Logo" height="30" class="d-inline-block align-text-top me-2">
                Dashboard Admin
            </a>
            <div class="d-flex">
                <a href="{{ route('admin.reports') }}" class="btn btn-light me-2">
                    <i class="bi bi-file-text"></i> Laporan
                </a>
                <a href="{{ route('admin.settings') }}" class="btn btn-light me-2">
                    <i class="bi bi-gear-fill"></i> Pengaturan
                </a>
                <form action="{{ route('admin.logout') }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-light">
                        <i class="bi bi-box-arrow-right"></i> Keluar
                    </button>
                </form>
            </div>
        </div>
    </nav>

    <div class="container">
        <!-- Ringkasan -->
        <div class="row mb-3">
            <div class="col-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-body py-3">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <h4 class="card-title mb-0">Ringkasan Hari Ini</h4>
                            <h6 class="text-muted mb-0">{{ now()->format('d F Y') }}</h6>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-3">
                                <div class="stat-card border-start border-5 border-primary p-3 h-100">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <h6 class="m-0">Pendaftaran Hari Ini</h6>
                                        <i class="bi bi-people fs-4 text-primary"></i>
                                    </div>
                                    <h3 class="mb-0">{{ $registrationsToday }}</h3>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stat-card border-start border-5 border-success p-3 h-100">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <h6 class="m-0">Antrian Online</h6>
                                        <i class="bi bi-globe fs-4 text-success"></i>
                                    </div>
                                    <h3 class="mb-0">{{ $onlineQueueToday }}</h3>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stat-card border-start border-5 border-warning p-3 h-100">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <h6 class="m-0">Antrian Offline</h6>
                                        <i class="bi bi-person-badge fs-4 text-warning"></i>
                                    </div>
                                    <h3 class="mb-0">{{ $offlineQueueToday }}</h3>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stat-card border-start border-5 border-info p-3 h-100">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <h6 class="m-0">Total Bulan Ini</h6>
                                        <i class="bi bi-calendar-month fs-4 text-info"></i>
                                    </div>
                                    <h3 class="mb-0">{{ $totalRegistrationsThisMonth }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tab Navigation -->
        <ul class="nav nav-tabs mb-3" id="dashboardTab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="queues-tab" data-bs-toggle="tab" data-bs-target="#queues" type="button" role="tab" aria-controls="queues" aria-selected="true">
                    <i class="bi bi-list-ol me-1"></i> Antrian Hari Ini
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="registrations-tab" data-bs-toggle="tab" data-bs-target="#registrations" type="button" role="tab" aria-controls="registrations" aria-selected="false">
                    <i class="bi bi-person-lines-fill me-1"></i> Data Pendaftar
                </button>
            </li>
        </ul>

        <!-- Tab Content -->
        <div class="tab-content" id="dashboardTabContent">
            <!-- Antrian Tab -->
            <div class="tab-pane fade show active" id="queues" role="tabpanel" aria-labelledby="queues-tab">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card border-0 shadow-sm mb-3">
                            <div class="card-header bg-success text-white">
                                <h5 class="card-title mb-0">
                                    <i class="bi bi-globe me-2"></i>
                                    Antrian Online Hari Ini
                                </h5>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-hover mb-0">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Nama</th>
                                                <th>Status</th>
                                                <th>Kode Booking</th>
                                                <th>Waktu Datang</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($onlineQueues as $queue)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $queue->name }}</td>
                                                <td>
                                                    @if($queue->status == 1)
                                                        <span class="badge bg-success">Terlayani</span>
                                                    @else
                                                        <span class="badge bg-warning">Menunggu</span>
                                                    @endif
                                                </td>
                                                <td>{{ $queue->booking_code }}</td>
                                                <td>{{ \Carbon\Carbon::parse($queue->waktudatang)->format('H:i') }}</td>
                                            </tr>
                                            @empty
                                            <tr>
                                                <td colspan="5" class="text-center">Tidak ada antrian online hari ini</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card border-0 shadow-sm mb-3">
                            <div class="card-header bg-warning text-dark">
                                <h5 class="card-title mb-0">
                                    <i class="bi bi-person-badge me-2"></i>
                                    Antrian Offline Hari Ini
                                </h5>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-hover mb-0">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Nama</th>
                                                <th>Status</th>
                                                <th>Nomor Antrian</th>
                                                <th>Waktu Datang</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($offlineQueues as $queue)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $queue->name }}</td>
                                                <td>
                                                    @if($queue->status == 1)
                                                        <span class="badge bg-success">Terlayani</span>
                                                    @else
                                                        <span class="badge bg-warning">Menunggu</span>
                                                    @endif
                                                </td>
                                                <td>{{ $queue->nomorantrian }}</td>
                                                <td>{{ \Carbon\Carbon::parse($queue->waktudatang)->format('H:i') }}</td>
                                            </tr>
                                            @empty
                                            <tr>
                                                <td colspan="5" class="text-center">Tidak ada antrian offline hari ini</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pendaftar Tab -->
            <div class="tab-pane fade" id="registrations" role="tabpanel" aria-labelledby="registrations-tab">
                <div class="card border-0 shadow-sm">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">Daftar Pendaftar Hari Ini</h5>
                        <form action="{{ route('admin.dashboard') }}" method="GET" class="d-flex">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="Cari nama/NIK..." name="search" value="{{ $search }}">
                                <button class="btn btn-primary" type="submit">
                                    <i class="bi bi-search"></i> Cari
                                </button>
                            </div>
                        </form>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">                                <thead>                                    <tr>
                                        <th width="40">No</th>
                                        <th class="col-name">Nama</th>
                                        <th class="col-nik">NIK</th>
                                        <th class="col-phone">No. Telp</th>
                                        <th class="col-address">Alamat</th>
                                        <th class="col-topic">Topik Aduan</th>
                                        <th>Status</th>
                                        <th>Pendamping</th>
                                        <th>Waktu Kunjungan</th>
                                        <th>Kode Booking</th>
                                        <th>KTP</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($todayRegistrations as $registration)
                                    <tr>                                        <td>{{ $loop->iteration }}</td>
                                        <td class="col-name">{{ $registration->name }}</td>
                                        <td class="col-nik">{{ $registration->nik }}</td>
                                        <td class="col-phone">{{ $registration->phone }}</td>
                                        <td class="col-address">{{ $registration->address }}</td>
                                        <td class="col-topic">{{ $registration->topic }}</td>
                                        <td>
                                            @if($registration->priority)
                                                <span class="badge bg-info">Kelompok Rentan/Difabel</span>
                                            @else
                                                <span class="badge bg-secondary">Reguler</span>
                                            @endif
                                        </td>
                                        <td>{{ $registration->pendamping ?: '-' }}</td>
                                        <td>{{ $registration->visit_time }}</td>
                                        <td>{{ $registration->booking_code }}</td>
                                        <td>
                                            @if($registration->ktp_image)
                                                <div class="btn-group">
                                                    <a href="{{ route('admin.serve.ktp', $registration) }}" 
                                                       class="btn btn-sm btn-info" 
                                                       target="_blank"
                                                       title="Lihat KTP">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                    <a href="{{ route('admin.download.ktp', $registration) }}" 
                                                       class="btn btn-sm btn-success"
                                                       title="Download KTP">
                                                        <i class="bi bi-download"></i>
                                                    </a>
                                                </div>
                                            @else
                                                <span class="badge bg-warning">Tidak ada KTP</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="10" class="text-center">Tidak ada pendaftar hari ini</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="d-flex justify-content-center mt-3 p-2">
                            {{ $todayRegistrations->links('pagination::bootstrap-5') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="footer mt-4 py-3 bg-white">
        <div class="container">
            <p class="text-center text-muted mb-0">&copy; {{ date('Y') }} Dashboard Admin Layanan Wapres</p>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Inisialisasi tab melalui Javascript
            var triggerTabList = [].slice.call(document.querySelectorAll('#dashboardTab button'));
            triggerTabList.forEach(function (triggerEl) {
                var tabTrigger = new bootstrap.Tab(triggerEl);
                triggerEl.addEventListener('click', function (event) {
                    event.preventDefault();
                    tabTrigger.show();
                });
            });
        });
    </script>
</body>
</html>
