<!-- resources/views/admin/import.blade.php -->
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Import Data Registrasi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="{{ asset('css/styles.css') }}" rel="stylesheet">
    <style>
        .tab-pane {
            padding: 15px 0;
        }
        .stat-card {
            transition: all 0.3s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }
        .table-responsive {
            max-height: 400px;
            overflow-y: auto;
        }
        .nav-tabs .nav-link {
            font-weight: 500;
        }
        .nav-tabs .nav-link.active {
            border-bottom: 3px solid #0d6efd;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-md navbar-dark bg-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="{{ route('admin.dashboard') }}">Admin Panel</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('admin.dashboard') }}">Dashboard</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('admin.registrations') }}">Registrasi</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('admin.reports') }}">Laporan</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="{{ route('admin.import') }}">Import</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('admin.settings') }}">Pengaturan</a>
                    </li>
                </ul>
                <div class="d-flex">
                    <form action="{{ route('admin.logout') }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-outline-light">Logout</button>
                    </form>
                </div>
            </div>
        </div>
    </nav>

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="card shadow mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 font-weight-bold text-primary">Import Data Registrasi dari CSV</h6>
                    </div>
                    <div class="card-body">
                        <!-- Import Instructions -->
                        <div class="alert alert-info mb-4">
                            <h5 class="font-weight-bold">Petunjuk Import Data:</h5>
                            <p>Pastikan file CSV Anda menggunakan format dengan kolom berikut (dipisahkan dengan semicolon ';'):</p>
                            <ol>
                                <li>Nama Lengkap</li>
                                <li>NIK (Nomor Identitas)</li>
                                <li>Nomor Kontak (format 08xxxx, akan otomatis dikonversi ke format 62xxxx)</li>
                                <li>Email (opsional)</li>
                                <li>Catatan Disabilitas (opsional)</li>
                                <li>Nama Pendamping (opsional)</li>
                                <li>Tanggal dan Waktu Reservasi (format: DD/MM/YYYY HH.MM)</li>
                                <li>Topik Aduan</li>
                            </ol>
                            <p>Contoh format: <code>John Doe;1234567890123456;085812345678;john@example.com;Ya;Jane Doe;12/08/2025 11.00;Administrasi sekolah</code></p>
                            <p><strong>Catatan:</strong> Sistem akan melakukan validasi data dan hanya mengimpor data yang valid.</p>
                        </div>

                        <!-- Import Form -->
                        <form action="{{ route('admin.import.process') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group mb-3">
                                <label for="csv_file" class="form-label">File CSV</label>
                                <input type="file" class="form-control @error('csv_file') is-invalid @enderror" id="csv_file" name="csv_file" accept=".csv,.txt">
                                @error('csv_file')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>                            <div class="form-check mb-3">
                                <input type="checkbox" class="form-check-input" id="has_header" name="has_header" checked>
                                <label class="form-check-label" for="has_header">File memiliki baris header (akan dilewati)</label>
                            </div>
                            <div class="form-check mb-3">
                                <input type="checkbox" class="form-check-input" id="replace_existing" name="replace_existing">
                                <label class="form-check-label" for="replace_existing">Replace data jika NIK/KTP sama (jika tidak dicentang, data dengan NIK yang sama akan dilewati)</label>
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-file-earmark-arrow-up me-1"></i> Import Data
                            </button>
                        </form>

                        <!-- Import Results -->
                        @if(session('import_results'))
                        <div class="mt-5">
                            <h5 class="font-weight-bold">Hasil Import:</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card bg-success text-white shadow mb-4">
                                        <div class="card-body">
                                            <div class="text-white-50 small">Berhasil Diimport</div>
                                            <div class="h3 mb-0 font-weight-bold text-white">{{ session('success_count') }} data</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card bg-danger text-white shadow mb-4">
                                        <div class="card-body">
                                            <div class="text-white-50 small">Gagal Diimport</div>
                                            <div class="h3 mb-0 font-weight-bold text-white">{{ session('error_count') }} data</div>
                                        </div>
                                    </div>
                                </div>
                            </div>                            @if(session('import_errors') && count(session('import_errors')) > 0)
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">Detail Error</h6>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th>No</th>
                                                    <th>Pesan Error</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach(session('import_errors') as $index => $error)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $error }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Add any custom JavaScript here if needed
        });
    </script>
</body>
</html>
