<!-- resources/views/admin/reports.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reports - Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="{{ asset('css/styles.css') }}" rel="stylesheet">
    <style>
        /* Column width adjustments */
        .col-address {
            min-width: 200px;
            max-width: 300px;
            white-space: normal;
            word-wrap: break-word;
        }
        .col-name {
            min-width: 150px;
        }
        .col-topic {
            min-width: 180px;
        }
        .col-nik {
            min-width: 130px;
        }
        .col-phone {
            min-width: 120px;
        }
        .col-email {
            min-width: 180px;
        }
        .table td {
            vertical-align: middle;
            word-break: break-word;
        }
        .table-responsive {
            overflow-x: auto;
        }
    </style>
</head>
<body class="bg-light">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary mb-4">
        <div class="container">
            <a class="navbar-brand" href="{{ route('admin.dashboard') }}">
                <i class="bi bi-arrow-left me-2"></i>
                Kembali ke Dashboard
            </a>
        </div>
    </nav>

    <div class="container">
        <div class="card shadow-sm">
            <div class="card-body">
                <h4 class="card-title mb-4">
                    <i class="bi bi-file-text me-2"></i>
                    Laporan Pendaftaran
                </h4>

                <!-- Report Type Selector -->
                <form action="{{ route('admin.reports') }}" method="GET" class="row g-3 mb-4">
                    <div class="col-md-3">
                        <label class="form-label">Jenis Laporan</label>
                        <select name="report_type" class="form-select" id="report-type">
                            <option value="online_registration" {{ request('report_type') == 'online_registration' ? 'selected' : '' }}>Pendaftaran Online</option>
                            <option value="all_queue" {{ request('report_type') == 'all_queue' ? 'selected' : '' }}>Antrian Semua</option>
                            <option value="online_queue" {{ request('report_type') == 'online_queue' ? 'selected' : '' }}>Antrian Online</option>
                            <option value="offline_queue" {{ request('report_type') == 'offline_queue' ? 'selected' : '' }}>Antrian Offline</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Bulan</label>
                        <select name="month" class="form-select">
                            <option value="">-- Semua Bulan --</option>
                            <option value="01" {{ request('month') == '01' ? 'selected' : '' }}>Januari</option>
                            <option value="02" {{ request('month') == '02' ? 'selected' : '' }}>Februari</option>
                            <option value="03" {{ request('month') == '03' ? 'selected' : '' }}>Maret</option>
                            <option value="04" {{ request('month') == '04' ? 'selected' : '' }}>April</option>
                            <option value="05" {{ request('month') == '05' ? 'selected' : '' }}>Mei</option>
                            <option value="06" {{ request('month') == '06' ? 'selected' : '' }}>Juni</option>
                            <option value="07" {{ request('month') == '07' ? 'selected' : '' }}>Juli</option>
                            <option value="08" {{ request('month') == '08' ? 'selected' : '' }}>Agustus</option>
                            <option value="09" {{ request('month') == '09' ? 'selected' : '' }}>September</option>
                            <option value="10" {{ request('month') == '10' ? 'selected' : '' }}>Oktober</option>
                            <option value="11" {{ request('month') == '11' ? 'selected' : '' }}>November</option>
                            <option value="12" {{ request('month') == '12' ? 'selected' : '' }}>Desember</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Tahun</label>
                        <select name="year" class="form-select">
                            <option value="">-- Semua Tahun --</option>
                            @php
                                $currentYear = (int)date('Y');
                                for($i = $currentYear; $i >= $currentYear - 5; $i--) {
                                    $selected = request('year') == $i ? 'selected' : '';
                                    echo "<option value=\"$i\" $selected>$i</option>";
                                }
                            @endphp
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Tanggal Mulai</label>
                        <input type="date" 
                               name="start_date" 
                               class="form-control"
                               value="{{ request('start_date') }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Tanggal Akhir</label>
                        <input type="date" 
                               name="end_date" 
                               class="form-control"
                               value="{{ request('end_date') }}">
                    </div>
                    <div class="col-md-9">
                        <label class="form-label">Cari</label>
                        <input type="text" 
                               name="search" 
                               class="form-control"
                               placeholder="Cari nama/NIK/kode booking..."
                               value="{{ request('search') }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-search me-2"></i>Tampilkan Laporan
                            </button>
                        </div>
                    </div>
                </form>

                <!-- Action Buttons -->
                <div class="d-flex flex-wrap gap-2 mb-4">
                    <!-- Export Button -->
                    <form action="{{ route('admin.reports.export') }}" method="POST" class="me-2">
                        @csrf
                        <input type="hidden" name="report_type" value="{{ request('report_type', 'online_registration') }}">
                        <input type="hidden" name="month" value="{{ request('month') }}">
                        <input type="hidden" name="year" value="{{ request('year') }}">
                        <input type="hidden" name="start_date" value="{{ request('start_date') }}">
                        <input type="hidden" name="end_date" value="{{ request('end_date') }}">
                        <input type="hidden" name="search" value="{{ request('search') }}">
                        <button type="submit" class="btn btn-success">
                            <i class="bi bi-file-excel me-2"></i>Export Data ke Excel
                        </button>
                    </form>
                    
                    <!-- Download KTP ZIP Button -->
                    <form action="{{ route('admin.download.ktp.zip') }}" method="POST">
                        @csrf
                        <input type="hidden" name="report_type" value="{{ request('report_type', 'online_registration') }}">
                        <input type="hidden" name="month" value="{{ request('month') }}">
                        <input type="hidden" name="year" value="{{ request('year') }}">
                        <input type="hidden" name="start_date" value="{{ request('start_date') }}">
                        <input type="hidden" name="end_date" value="{{ request('end_date') }}">
                        <button type="submit" class="btn btn-info text-white">
                            <i class="bi bi-file-zip me-2"></i>Download KTP ZIP
                        </button>
                    </form>
                </div>

                <!-- Registrations Table -->
                <div class="table-responsive">
                    @if(request('report_type') == 'online_registration' || request('report_type') == '')                    <table class="table table-striped">                        <thead>
                            <tr>
                                <th width="40">No</th>
                                <th>Kode Booking</th>
                                <th class="col-name">Nama</th>
                                <th class="col-nik">NIK</th>
                                <th class="col-phone">No. Telp</th>
                                <th class="col-email">Email</th>
                                <th class="col-address">Alamat</th>
                                <th class="col-topic">Topik Aduan</th>
                                <th>Status</th>
                                <th>Pendamping</th>
                                <th>Tanggal</th>
                                <th>Jam</th>
                                <th>KTP</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($registrations as $registration)
                            <tr>                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $registration->booking_code }}</td>
                                <td class="col-name">{{ $registration->name }}</td>
                                <td class="col-nik">{{ $registration->nik }}</td>
                                <td class="col-phone">{{ $registration->phone }}</td>
                                <td class="col-email">{{ $registration->email ?: '-' }}</td>
                                <td class="col-address">{{ $registration->address ?: '-' }}</td>
                                <td class="col-topic">{{ $registration->topic }}</td>
                                <td>
                                    @if($registration->priority)
                                        <span class="badge bg-info">Kelompok Rentan/Difabel</span>
                                    @else
                                        <span class="badge bg-secondary">Reguler</span>
                                    @endif
                                </td>
                                <td>{{ $registration->pendamping ?: '-' }}</td>
                                <td>{{ \Carbon\Carbon::parse($registration->visit_date)->format('d/m/Y') }}</td>
                                <td>{{ $registration->visit_time }}</td>
                                <td>
                                    @if($registration->ktp_image)
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('admin.serve.ktp', $registration->id) }}" 
                                           class="btn btn-outline-primary" 
                                           target="_blank" 
                                           title="Lihat KTP">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    </div>
                                    @else
                                    <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="12" class="text-center">Tidak ada data</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                    @elseif(request('report_type') == 'all_queue' || request('report_type') == 'online_queue' || request('report_type') == 'offline_queue')
                    <table class="table table-striped">                        <thead>
                            <tr>
                                <th width="40">No</th>
                                <th>No. Antrian</th>
                                <th>Kode Booking</th>
                                <th class="col-name">Nama</th>
                                <th class="col-nik">NIK</th>
                                <th>No. KK</th>
                                <th class="col-phone">No. Telp</th>
                                <th class="col-topic">Topik Aduan</th>
                                <th>Status</th>
                                <th>Tipe Registrasi</th>
                                <th>Pendamping</th>
                                <th>Waktu Kedatangan</th>
                                <th>KTP</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transactions as $trx)
                            <tr>                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $trx->nomorantrian }}</td>
                                <td>{{ $trx->booking_code != '-' ? $trx->booking_code : '-' }}</td>
                                <td class="col-name">{{ $trx->name }}</td>
                                <td class="col-nik">{{ $trx->nik }}</td>
                                <td>{{ $trx->no_kk ?: '-' }}</td>
                                <td class="col-phone">{{ $trx->phone }}</td>
                                <td class="col-topic">{{ $trx->topic }}</td>
                                <td>
                                    @if($trx->priority)
                                        <span class="badge bg-info">Kelompok Rentan/Difabel</span>
                                    @else
                                        <span class="badge bg-secondary">Reguler</span>
                                    @endif
                                </td>
                                <td>
                                    @if($trx->id_online)
                                        <span class="badge bg-primary">Online</span>
                                    @else
                                        <span class="badge bg-warning text-dark">Offline</span>
                                    @endif
                                </td>
                                <td>{{ $trx->pendamping ?: '-' }}</td>
                                <td>{{ \Carbon\Carbon::parse($trx->waktudatang)->format('d/m/Y H:i:s') }}</td>
                                <td>
                                    @if($trx->ktp_image)
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('admin.serve.transaction.ktp', $trx->id) }}" 
                                           class="btn btn-outline-primary" 
                                           target="_blank" 
                                           title="Lihat KTP">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    </div>
                                    @else
                                    <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="13" class="text-center">Tidak ada data</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                    @endif
                </div>                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    @if(request('report_type') == 'online_registration' || request('report_type') == '')
                        {{ $registrations->appends(request()->query())->links('pagination::bootstrap-5') }}
                    @else
                        {{ $transactions->appends(request()->query())->links('pagination::bootstrap-5') }}
                    @endif
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>