<!-- resources/views/admin/settings.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Settings</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="{{ asset('css/styles.css') }}" rel="stylesheet">
    <style>
        /* Compact UI Styles */
        body {
            background-color: #f5f7fa;
        }
        .card {
            margin-bottom: 1.5rem;
            border: none;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
            border-radius: 0.75rem;
            transition: box-shadow 0.3s ease;
        }
        .card:hover {
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,.1);
        }
        .card-header {
            border-top-left-radius: 0.75rem !important;
            border-top-right-radius: 0.75rem !important;
            background-color: #fff;
            border-bottom: 1px solid rgba(0,0,0,.05);
        }
        .card-body {
            padding: 1.25rem;
        }
        .card-title {
            margin-bottom: 0.75rem;
            font-size: 1.1rem;
            font-weight: 600;
            color: #344767;
        }
        .form-label {
            margin-bottom: 0.25rem;
            color: #344767;
            font-weight: 500;
        }
        .form-control {
            border-radius: 0.5rem;
        }
        .form-control:focus {
            box-shadow: 0 0 0 0.15rem rgba(13,110,253,.25);
        }
        .btn {
            border-radius: 0.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.075);
            transition: all 0.2s ease;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
        .table {
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
        }
        .table-responsive {
            border-radius: 0.5rem;
            overflow: hidden;
        }
        .table td, .table th {
            padding: 0.75rem;
            font-size: 0.9rem;
        }
        .table thead th {
            font-weight: 600;
            color: #344767;
            border-bottom-width: 1px;
        }
        .badge {
            font-weight: 500;
            padding: 0.35em 0.65em;
            border-radius: 0.375rem;
        }
        .alert {
            border-radius: 0.5rem;
        }

        /* Side Navigation Styles */
        .settings-container {
            display: flex;
            min-height: calc(100vh - 60px);
        }
        .settings-nav {
            width: 280px;
            background-color: #fff;
            border-right: 1px solid rgba(0,0,0,.05);
            padding: 1.5rem 0;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,.035);
            overflow-y: auto;
        }
        .settings-content {
            flex: 1;
            padding: 2rem;
            overflow-y: auto;
            max-width: 1200px;
            margin: 0 auto;
        }
        .nav-link {
            color: #495057;
            border-left: 3px solid transparent;
            padding: 0.75rem 1.5rem;
            transition: all 0.2s;
            border-radius: 0;
            margin-bottom: 0.25rem;
        }
        .nav-link:hover {
            background-color: #f8f9fa;
            color: #0d6efd;
        }
        .nav-link.active {
            color: #0d6efd;
            border-left-color: #0d6efd;
            background-color: rgba(13, 110, 253, 0.08);
            font-weight: 600;
        }
        .nav-link i {
            margin-right: 0.75rem;
            font-size: 1.1rem;
        }
        .setting-section {
            display: none;
            animation: fadeIn 0.3s ease;
        }
        .setting-section.active {
            display: block;
        }
        .btn-toggle-menu {
            display: none;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @media (max-width: 992px) {
            .settings-container {
                flex-direction: column;
            }
            .settings-nav {
                width: 100%;
                border-right: none;
                border-bottom: 1px solid rgba(0,0,0,.05);
                padding: 1rem 0;
            }
            .btn-toggle-menu {
                display: block;
            }
            .settings-nav-items {
                display: none;
            }
            .settings-nav-items.show {
                display: block;
            }
            .settings-content {
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body class="bg-light">
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="{{ route('admin.dashboard') }}">
                <i class="bi bi-arrow-left me-2"></i>
                Kembali ke Dashboard
            </a>
        </div>
    </nav>

    <div class="container-fluid p-0">
        <div class="settings-container">
            <!-- Side Navigation -->
            <div class="settings-nav">
                <div class="d-flex justify-content-between align-items-center px-4 mb-4">
                    <h5 class="mb-0 fw-bold text-primary">Pengaturan Aplikasi</h5>
                    <button class="btn btn-sm btn-outline-primary rounded-circle btn-toggle-menu d-lg-none">
                        <i class="bi bi-list"></i>
                    </button>
                </div>
                <div class="settings-nav-items show">
                    <div class="list-group list-group-flush px-2">
                        <a href="#time-slots" class="list-group-item list-group-item-action nav-link active" data-section="time-slots">
                            <i class="bi bi-clock text-primary"></i> Jam Booking dan Kuota
                        </a>
                        <a href="#registration-period" class="list-group-item list-group-item-action nav-link" data-section="registration-period">
                            <i class="bi bi-calendar-range text-primary"></i> Periode Registrasi
                        </a>
                        <a href="#password" class="list-group-item list-group-item-action nav-link" data-section="password">
                            <i class="bi bi-shield-lock text-primary"></i> Ganti Password
                        </a>
                        <a href="#holidays" class="list-group-item list-group-item-action nav-link" data-section="holidays">
                            <i class="bi bi-calendar-event text-primary"></i> Hari Libur
                        </a>
                    </div>
                </div>
            </div>

            <!-- Content Area -->
            <div class="settings-content">
                <!-- Time Slots Section -->
                <div id="time-slots" class="setting-section active">
                    <h4 class="mb-4 fw-bold text-dark">
                        <i class="bi bi-clock me-2 text-primary"></i>
                        Pengaturan Jam Booking dan Kuota
                    </h4>
                    
                    <div class="card shadow-sm">
                        <div class="card-header bg-white py-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="card-title mb-0">
                                    Daftar Slot Waktu
                                </h6>
                                <button type="button" class="btn btn-sm btn-success px-3" data-bs-toggle="modal" data-bs-target="#addTimeSlotModal">
                                    <i class="bi bi-plus-circle me-1"></i> Tambah Slot
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover mb-0" id="timeSlotsTable">
                                    <thead class="table-light">
                                        <tr>
                                            <th style="width: 50px" class="text-center">#</th>
                                            <th>Waktu</th>
                                            <th>Label</th>
                                            <th>Kuota</th>
                                            <th>Status</th>
                                            <th style="width: 120px" class="text-center">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody id="timeSlotsList">
                                        @if($timeSlots->count() > 0)
                                            @foreach($timeSlots as $slot)
                                            <tr data-id="{{ $slot->id }}">
                                                <td class="text-center">
                                                    <i class="bi bi-grip-vertical handle" style="cursor: move"></i>
                                                </td>
                                                <td>{{ $slot->time }}</td>
                                                <td>{{ $slot->label }}</td>
                                                <td>{{ $slot->quota }}</td>
                                                <td>
                                                    @if($slot->is_active)
                                                    <span class="badge bg-success">Aktif</span>
                                                    @else
                                                    <span class="badge bg-secondary">Nonaktif</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-sm">
                                                        <button type="button" class="btn btn-primary edit-timeslot" 
                                                            data-bs-toggle="modal" 
                                                            data-bs-target="#editTimeSlotModal"
                                                            data-id="{{ $slot->id }}"
                                                            data-time="{{ $slot->time }}"
                                                            data-label="{{ $slot->label }}"
                                                            data-quota="{{ $slot->quota }}"
                                                            data-active="{{ $slot->is_active }}">
                                                            <i class="bi bi-pencil"></i>
                                                        </button>
                                                        <form action="{{ route('admin.time-slots.delete', $slot->id) }}" method="POST" class="d-inline delete-timeslot-form">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger">
                                                                <i class="bi bi-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td colspan="6" class="text-center py-4">
                                                    <div class="text-muted">
                                                        <i class="bi bi-calendar-x fs-3 d-block mb-2"></i>
                                                        Belum ada slot waktu yang dikonfigurasi
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                            
                            <div class="alert alert-info m-3 mb-2">
                                <small><i class="bi bi-info-circle me-2"></i> 
                                Anda dapat mengatur ulang urutan slot waktu dengan drag and drop pada tabel di atas.</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Registration Period Section -->
                <div id="registration-period" class="setting-section">
                    <h4 class="mb-4 fw-bold text-dark">
                        <i class="bi bi-calendar-range me-2 text-primary"></i>
                        Pengaturan Periode Registrasi
                    </h4>
                    
                    <div class="card shadow-sm">
                        <div class="card-header bg-white py-3">
                            <h6 class="card-title mb-0">
                                Rentang Tanggal Registrasi
                            </h6>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.settings.update') }}" method="POST">
                                @csrf
                                <div class="row g-3">
                                    <div class="col-md-5">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Tanggal Mulai Registrasi</label>
                                            <input type="date" 
                                                   name="registration_start_date" 
                                                   class="form-control @error('registration_start_date') is-invalid @enderror" 
                                                   value="{{ $settings['registration_start_date'] ?? '' }}"
                                                   required>
                                            @error('registration_start_date')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Tanggal Akhir Registrasi</label>
                                            <input type="date" 
                                                   name="registration_end_date" 
                                                   class="form-control @error('registration_end_date') is-invalid @enderror" 
                                                   value="{{ $settings['registration_end_date'] ?? '' }}"
                                                   required>
                                            @error('registration_end_date')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-2 d-flex align-items-end">
                                        <button type="submit" class="btn btn-primary w-100 mb-3">
                                            <i class="bi bi-save me-2"></i>Simpan
                                        </button>
                                    </div>
                                </div>
                                
                                <div class="alert alert-info mb-0 mt-2">
                                    <i class="bi bi-info-circle me-2"></i> 
                                    Rentang tanggal ini menentukan periode waktu yang tersedia untuk registrasi. 
                                    Tanggal di luar periode ini akan ditandai sebagai tidak tersedia.
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Password Section -->                <div id="password" class="setting-section">
                    <h4 class="mb-4 fw-bold text-dark">
                        <i class="bi bi-shield-lock me-2 text-primary"></i>
                        Ganti Password
                    </h4>
                    
                    <div class="card shadow-sm">
                        <div class="card-header bg-white py-3">
                            <h6 class="card-title mb-0">
                                Update Password Admin
                            </h6>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.settings.update') }}" method="POST">
                                @csrf
                                <input type="hidden" name="max_daily_queue" value="{{ $settings['max_daily_queue'] ?? '' }}">
                                
                                <div class="row justify-content-center">
                                    <div class="col-md-8">
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Password Lama</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light">
                                                    <i class="bi bi-lock"></i>
                                                </span>
                                                <input type="password" 
                                                    name="old_password" 
                                                    class="form-control @error('old_password') is-invalid @enderror">
                                                @error('old_password')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Password Baru</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light">
                                                    <i class="bi bi-key"></i>
                                                </span>
                                                <input type="password" 
                                                    name="new_password" 
                                                    class="form-control @error('new_password') is-invalid @enderror">
                                                @error('new_password')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Konfirmasi Password</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light">
                                                    <i class="bi bi-check2-circle"></i>
                                                </span>
                                                <input type="password" 
                                                    name="new_password_confirmation" 
                                                    class="form-control">
                                            </div>
                                        </div>
                                        
                                        <div class="d-grid gap-2">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bi bi-arrow-clockwise me-1"></i> Update Password
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Holidays Section -->
                <div id="holidays" class="setting-section">
                    <h4 class="mb-4 fw-bold text-dark">
                        <i class="bi bi-calendar-event me-2 text-primary"></i>
                        Pengaturan Hari Libur
                    </h4>
                    
                    <div class="row g-4">
                        <!-- Holiday Input Form -->
                        <div class="col-md-5">
                            <div class="card shadow-sm h-100">
                                <div class="card-header bg-white py-3">
                                    <h6 class="card-title mb-0">
                                        Tambah Hari Libur Baru
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('admin.holiday.store') }}" method="POST">
                                        @csrf
                                        <div class="row g-3">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label fw-bold">Tanggal Mulai</label>
                                                    <input type="date" 
                                                           name="start_date" 
                                                           class="form-control @error('start_date') is-invalid @enderror"
                                                           min="{{ date('Y-m-d') }}"
                                                           required>
                                                    @error('start_date')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label fw-bold">Tanggal Akhir</label>
                                                    <input type="date" 
                                                           name="end_date" 
                                                           class="form-control @error('end_date') is-invalid @enderror"
                                                           min="{{ date('Y-m-d') }}"
                                                           required>
                                                    @error('end_date')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label fw-bold">Keterangan</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light">
                                                    <i class="bi bi-info-circle"></i>
                                                </span>
                                                <input type="text" 
                                                       name="description" 
                                                       class="form-control @error('description') is-invalid @enderror"
                                                       placeholder="Contoh: Hari Raya Idul Fitri"
                                                       required>
                                                @error('description')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="d-grid">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bi bi-plus-circle me-2"></i> Tambah Hari Libur
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Holiday List Table -->
                        <div class="col-md-7">
                            <div class="card shadow-sm h-100">
                                <div class="card-header bg-white py-3">
                                    <h6 class="card-title mb-0">
                                        Daftar Hari Libur
                                    </h6>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-hover mb-0">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>Rentang Tanggal</th>
                                                    <th>Keterangan</th>
                                                    <th style="width:80px" class="text-center">Aksi</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($holidays as $holiday)
                                                <tr>
                                                    <td>{{ $holiday->date_range }}</td>
                                                    <td>{{ $holiday->description }}</td>
                                                    <td class="text-center">
                                                        <form action="{{ route('admin.holiday.delete', $holiday->id) }}" 
                                                              method="POST" 
                                                              class="d-inline"
                                                              onsubmit="return confirm('Yakin ingin menghapus hari libur ini?')">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger btn-sm">
                                                                <i class="bi bi-trash"></i>
                                                            </button>
                                                        </form>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="3" class="text-center py-4">
                                                        <div class="text-muted">
                                                            <i class="bi bi-calendar-x fs-3 d-block mb-2"></i>
                                                            Belum ada hari libur yang ditambahkan
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Time Slot Modal -->
    <div class="modal fade" id="addTimeSlotModal" tabindex="-1" aria-labelledby="addTimeSlotModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="addTimeSlotModalLabel">
                        <i class="bi bi-plus-circle me-2"></i>
                        Tambah Slot Waktu
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('admin.time-slots.store') }}" method="POST">
                    @csrf
                    <div class="modal-body p-4">
                        <div class="mb-3">
                            <label for="time" class="form-label fw-bold">Waktu</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light">
                                    <i class="bi bi-clock"></i>
                                </span>
                                <input type="time" class="form-control" id="time" name="time" required>
                            </div>
                            <small class="text-muted mt-1 d-block">Format: 24 jam (contoh: 08:00, 13:30)</small>
                        </div>
                        <div class="mb-3">
                            <label for="label" class="form-label fw-bold">Label</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light">
                                    <i class="bi bi-tag"></i>
                                </span>
                                <input type="text" class="form-control" id="label" name="label" placeholder="Pagi" required>
                            </div>
                            <small class="text-muted mt-1 d-block">Label untuk tampilan (contoh: Pagi, Siang, Sore)</small>
                        </div>
                        <div class="mb-3">
                            <label for="quota" class="form-label fw-bold">Kuota</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light">
                                    <i class="bi bi-people"></i>
                                </span>
                                <input type="number" class="form-control" id="quota" name="quota" min="0" value="15" required>
                            </div>
                            <small class="text-muted mt-1 d-block">Tetapkan ke 0 untuk menonaktifkan slot waktu ini</small>
                        </div>
                        <div class="form-check mb-0">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                            <label class="form-check-label" for="is_active">
                                Aktif
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer border-top-0">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            <i class="bi bi-x-circle me-1"></i> Batal
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-1"></i> Simpan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Edit Time Slot Modal -->
    <div class="modal fade" id="editTimeSlotModal" tabindex="-1" aria-labelledby="editTimeSlotModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="editTimeSlotModalLabel">
                        <i class="bi bi-pencil-square me-2"></i>
                        Edit Slot Waktu
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editTimeSlotForm" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="modal-body p-4">
                        <div class="mb-3">
                            <label for="editTime" class="form-label fw-bold">Waktu</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light">
                                    <i class="bi bi-clock"></i>
                                </span>
                                <input type="time" class="form-control" id="editTime" name="time" required>
                            </div>
                            <small class="text-muted mt-1 d-block">Format: 24 jam (contoh: 08:00, 13:30)</small>
                        </div>
                        <div class="mb-3">
                            <label for="editLabel" class="form-label fw-bold">Label</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light">
                                    <i class="bi bi-tag"></i>
                                </span>
                                <input type="text" class="form-control" id="editLabel" name="label" placeholder="Pagi" required>
                            </div>
                            <small class="text-muted mt-1 d-block">Label untuk tampilan (contoh: Pagi, Siang, Sore)</small>
                        </div>
                        <div class="mb-3">
                            <label for="editQuota" class="form-label fw-bold">Kuota</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light">
                                    <i class="bi bi-people"></i>
                                </span>
                                <input type="number" class="form-control" id="editQuota" name="quota" min="0" required>
                            </div>
                            <small class="text-muted mt-1 d-block">Tetapkan ke 0 untuk menonaktifkan slot waktu ini</small>
                        </div>
                        <div class="form-check mb-0">
                            <input class="form-check-input" type="checkbox" id="editIsActive" name="is_active">
                            <label class="form-check-label" for="editIsActive">
                                Aktif
                            </label>
                        </div>
                    </div>
                    <div class="modal-footer border-top-0">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            <i class="bi bi-x-circle me-1"></i> Batal
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-1"></i> Simpan Perubahan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.14.0/Sortable.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Handle section navigation with smooth transitions
            const navLinks = document.querySelectorAll('.nav-link');
            const sections = document.querySelectorAll('.setting-section');
            
            navLinks.forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    // Update active nav link with visual feedback
                    navLinks.forEach(item => {
                        item.classList.remove('active');
                        item.style.transition = 'all 0.3s ease';
                    });
                    this.classList.add('active');
                    
                    // Show selected section with animation, hide others
                    const targetSection = this.getAttribute('data-section');
                    sections.forEach(section => {
                        section.classList.remove('active');
                        section.style.transition = 'all 0.3s ease';
                    });
                    
                    // Add small delay for animation
                    setTimeout(() => {
                        document.getElementById(targetSection).classList.add('active');
                    }, 50);
                    
                    // For mobile: close nav after selection
                    if(window.innerWidth < 992) {
                        document.querySelector('.settings-nav-items').classList.remove('show');
                    }
                    
                    // Update URL hash
                    window.location.hash = targetSection;
                });
            });
            
            // Handle menu toggle for mobile view
            const btnToggleMenu = document.querySelector('.btn-toggle-menu');
            if (btnToggleMenu) {
                btnToggleMenu.addEventListener('click', function() {
                    document.querySelector('.settings-nav-items').classList.toggle('show');
                });
            }
            
            // Check URL hash on page load
            if(window.location.hash) {
                const hash = window.location.hash.substring(1);
                const targetLink = document.querySelector(`.nav-link[data-section="${hash}"]`);
                if(targetLink) {
                    targetLink.click();
                }
            }
            
            // Initialize sortable for time slots drag-and-drop reordering
            const timeSlotsList = document.getElementById('timeSlotsList');
            if (timeSlotsList) {
                new Sortable(timeSlotsList, {
                    animation: 150,
                    handle: '.handle',
                    ghostClass: 'bg-light',
                    onEnd: function() {
                        // Get the new order of time slots
                        const rows = timeSlotsList.querySelectorAll('tr');
                        const ids = Array.from(rows).map(row => row.getAttribute('data-id'));
                        
                        // Save the new order via AJAX
                        fetch('{{ route("admin.time-slots.reorder") }}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            },
                            body: JSON.stringify({ ids: ids })
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                console.log('Time slots reordered successfully');
                                
                                // Show success feedback
                                const alert = document.createElement('div');
                                alert.className = 'alert alert-success alert-dismissible fade show';
                                alert.innerHTML = '<i class="bi bi-check-circle me-2"></i> Urutan slot waktu berhasil diperbarui <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
                                
                                const content = document.querySelector('#time-slots .card-body');
                                content.insertBefore(alert, content.firstChild);
                                
                                // Auto-dismiss after 3 seconds
                                setTimeout(() => {
                                    alert.classList.remove('show');
                                    setTimeout(() => alert.remove(), 300);
                                }, 3000);
                            }
                        })
                        .catch(error => {
                            console.error('Error saving time slot order:', error);
                        });
                    }
                });
            }
            
            // Confirm delete for time slots with nicer UX
            const deleteTimeSlotForms = document.querySelectorAll('.delete-timeslot-form');
            deleteTimeSlotForms.forEach(form => {
                form.addEventListener('submit', function(e) {
                    e.preventDefault();
                    if (confirm('Yakin ingin menghapus slot waktu ini? Tindakan ini tidak dapat dibatalkan.')) {
                        // Show loading state
                        const submitBtn = this.querySelector('button[type="submit"]');
                        const originalContent = submitBtn.innerHTML;
                        submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>';
                        submitBtn.disabled = true;
                        
                        this.submit();
                    }
                });
            });
            
            // Handle edit time slot button clicks
            const editButtons = document.querySelectorAll('.edit-timeslot');
            editButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const id = this.getAttribute('data-id');
                    const time = this.getAttribute('data-time');
                    const label = this.getAttribute('data-label');
                    const quota = this.getAttribute('data-quota');
                    const isActive = this.getAttribute('data-active') === '1';
                    
                    // Convert HH:MM to HH:MM format for time input
                    const [hours, minutes] = time.split(':');
                    const formattedTime = `${hours.padStart(2, '0')}:${minutes.padStart(2, '0')}`;
                    
                    // Update form fields
                    document.getElementById('editTime').value = formattedTime;
                    document.getElementById('editLabel').value = label;
                    document.getElementById('editQuota').value = quota;
                    document.getElementById('editIsActive').checked = isActive;
                    
                    // Set form action URL
                    document.getElementById('editTimeSlotForm').action = '/admin/time-slots/' + id;
                });
            });
        });
    </script>
</body>
</html>