<!-- resources/views/booking-print.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lapor Mas Wapres</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @page {
            size: A4;
            margin: 15mm;
        }
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
        }
        .page {
            width: 210mm;
            min-height: 297mm;
            padding: 10mm;
            margin: 0 auto;
            box-sizing: border-box;
            page-break-after: always;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #075ea5;
            padding-bottom: 10px;
        }
        .booking-code {
            font-size: 26px;
            color: #075ea5;
            font-weight: bold;
            margin: 15px 0;
        }
        .qr-code {
            display: block;
            margin: 0 auto;
            max-width: 150px;
            max-height: 150px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table, th, td {
            border: 1px solid #dee2e6;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f8f9fa;
            width: 30%;
        }
        .terms-title {
            color: #075ea5;
            font-weight: bold;
            margin-top: 15px;
            margin-bottom: 5px;
        }
        .alert-important {
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #6c757d;
            border-top: 1px solid #dee2e6;
            padding-top: 10px;
        }
        .no-print-button {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 999;
        }
        .terms-content {
            font-size: 0.9em;
        }
        .terms-content ul {
            padding-left: 20px;
            margin-bottom: 10px;
        }
        .terms-content p {
            margin-bottom: 5px;
        }
        .signature-area {
            margin-top: 30px;
            border-top: 1px dotted #000;
            width: 200px;
            text-align: center;
            padding-top: 5px;
        }
        .signature-container {
            display: flex;
            justify-content: flex-end;
            margin-top: 30px;
            margin-bottom: 20px;
        }
        .signature-date {
            margin-bottom: 50px;
            font-style: italic;
        }
        @media print {
            .no-print-button {
                display: none;
            }
            html, body {
                width: 210mm;
                height: 297mm;
            }
            .page {
                margin: 0;
                border: initial;
                border-radius: initial;
                width: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                page-break-after: always;
            }
        }
    </style>
</head>
<body>
    <button onclick="window.print()" class="btn btn-primary no-print-button">Cetak Dokumen</button>

    <!-- Page 1: Booking Information -->
    <div class="page">
        <div class="header">
            <img src="{{ asset('images/logo.png') }}" alt="Logo" height="60">
            <h2>LAPOR MAS WAPRES</h2>
        </div>

        <div class="text-center">
            <div class="booking-code">KODE BOOKING: {{ $booking->booking_code }}</div>
            <div class="qr-code">
                {!! QrCode::size(150)->generate($booking->booking_code) !!}
            </div>
        </div>

        <h5 class="mt-4 mb-3">DETAIL REGISTRASI:</h5>
        <table class="table table-bordered">
            <tbody>
                <tr>
                    <th>Nama</th>
                    <td>{{ $booking->name }}</td>
                </tr>
                <tr>
                    <th>Jenis Kelamin</th>
                    <td>{{ $booking->gender === 'L' ? 'Laki-laki' : 'Perempuan' }}</td>
                </tr>
                <tr>
                    <th>NIK</th>
                    <td>{{ $booking->nik }}</td>
                </tr>
                <tr>
                    <th>Nomor KK</th>
                    <td>{{ $booking->no_kk }}</td>
                </tr>
                <tr>
                    <th>Email</th>
                    <td>{{ $booking->email }}</td>
                </tr>                <tr>
                    <th>No. Telepon</th>
                    <td>{{ $booking->phone }}</td>
                </tr>
                <tr>
                    <th>Alamat</th>
                    <td>{{ $booking->address }}</td>
                </tr>
                <tr>
                    <th>Topik Aduan</th>
                    <td>{{ $booking->topic }}</td>
                </tr>
                @if($booking->priority)
                <tr>
                    <th>Status</th>
                    <td>
                        <span>Kelompok Rentan/Difabel</span>
                    </td>
                </tr>
                @endif
                @if($booking->pendamping)
                <tr>
                    <th>Nama Pendamping</th>
                    <td>{{ $booking->pendamping }}</td>
                </tr>
                @endif
                <tr>
                    <th>Tanggal Kunjungan</th>
                    <td>{{ date('d/m/Y', strtotime($booking->visit_date)) }}</td>
                </tr>
                <tr>
                    <th>Jam Kunjungan</th>
                    <td>{{ $booking->visit_time }} WIB</td>
                </tr>
            </tbody>
        </table>

        <div class="alert-important">
            <strong>PENTING!</strong><br>
            Harap tiba 15 menit sebelum waktu yang ditentukan. Bawa dokumen pendukung dan tunjukkan kode booking ini kepada petugas saat registrasi.
        </div>

        <div class="footer">
            <p>Dokumen ini dicetak pada: {{ date('d-m-Y H:i:s') }}</p>
            <p>Alamat: Kantor Sekretariat Wakil Presiden, Jalan Kebon Sirih No. 14, Jakarta Pusat</p>
        </div>
    </div>

    <!-- Page 2: Terms and Conditions (Part 1) -->
    <div class="page">
        <div class="header">
            <img src="{{ asset('images/logo.png') }}" alt="Logo" height="60">
            <h2>LAPOR MAS WAPRES</h2>
            <h4>SYARAT DAN KETENTUAN</h4>
        </div>

        <div class="terms-content">
            <h5 class="terms-title">KETENTUAN UMUM</h5>
            <p>Pelayanan program Lapor Mas Wapres! diselenggarakan di Kantor Sekretariat Wakil Presiden, Jalan Kebon Sirih No. 14, Jakarta Pusat, pada hari kerja:</p>
            <ul>
                <li>Senin s.d. Kamis, pukul 08.00 s.d. 14.00 WIB (istirahat, pukul 12.00 s.d. 13.00 WIB)</li>
                <li>Jumat, pukul 08.00 s.d. 14.30 WIB (istirahat, pukul 11.00 s.d. 13.30 WIB)</li>
            </ul>
            <ul>
                <li>Pelapor memakai pakaian bebas rapi.</li>
                <li>Pelapor wajib membawa kartu identitas (KTP/SIM/Identitas lain yang tercantum NIK).</li>
                <li>Pengaduan yang dilayani berjumlah maksimal 50 orang/hari.</li>
            </ul>

            <h5 class="terms-title">KETENTUAN PENGADUAN</h5>
            <ul>
                <li>Pelapor adalah orang yang langsung mengalami kejadian. Apabila pelapor bukan yang mengalami kejadian langsung, maka pelapor harus membawa surat kuasa bermaterai dari pihak yang diwakili.</li>
                <li>Substansi aduan tidak sedang atau telah menjadi objek peradilan.</li>
                <li>Substansi aduan belum pernah disampaikan oleh pelapor kepada Wakil Presiden.</li>
                <li>Pelapor wajib membawa dokumen pendukung pengaduan yang lengkap dan relevan.</li>
                <li>Petugas memverifikasi dokumen pengaduan. Apabila dokumen tidak lengkap, petugas akan meminta pelapor untuk mengirimkan kelengkapan dokumen melalui surel lapormaswapres@set.wapresri.go.id</li>
                <li>Pelapor wajib menyampaikan nomor kontak atau surel yang dapat dihubungi.</li>
            </ul>

            <h5 class="terms-title">REGISTRASI DAN PROSES PENGADUAN</h5>
            <ul>
                <li>Pelapor melakukan registrasi secara online melalui https://lapormaswapres.id</li>
                <li>Pelapor yang telah berhasil melakukan registrasi online, harap hadir sesuai tanggal yang dipilih.</li>
                <li>Pelapor menunggu di ruang tunggu yang telah disediakan.</li>
                <li>Petugas memverifikasi dan memberikan nomor antrian pengaduan.</li>
                <li>Petugas mempersilahkan pelapor ke Ruang Pengaduan berdasarkan nomor antrian.</li>
            </ul>
        </div>

        <div class="footer">
            <p>Halaman 2 dari 3</p>
            <p>Sekretariat Wakil Presiden Republik Indonesia</p>
        </div>
    </div>

    <!-- Page 3: Terms and Conditions (Part 2) and Signature -->
    <div class="page">
        <div class="header">
            <img src="{{ asset('images/logo.png') }}" alt="Logo" height="60">
            <h2>LAPOR MAS WAPRES</h2>
            <h4>SYARAT DAN KETENTUAN (LANJUTAN)</h4>
        </div>

        <div class="terms-content">
            <h5 class="terms-title">HAL-HAL LAIN</h5>
            <ul>
                <li>Pelapor menghormati tata tertib yang berlaku, menjaga etika dan kesopanan selama berada di lingkungan Sekretariat Wakil Presiden.</li>
                <li>Pelapor dilarang mengambil gambar/video dan membuat konten selama proses pelaporan.</li>
                <li>Pelapor harus menaati seluruh ketentuan dalam Tata Tertib Lapor Mas Wapres! dan ketentuan lain yang ditetapkan di kemudian hari.</li>
            </ul>

            <div class="alert-important mt-4">
                <strong>PERNYATAAN PERSETUJUAN</strong><br>
                Dengan menandatangani dokumen ini, saya menyatakan telah membaca, memahami, dan menyetujui seluruh syarat dan ketentuan Lapor Mas Wapres yang telah diuraikan di atas. Saya bersedia untuk mematuhi seluruh ketentuan dan tata tertib yang berlaku di lingkungan Sekretariat Wakil Presiden.
            </div>

            <div class="signature-container">
                <div>
                    <p class="signature-date">Jakarta, {{ date('d F Y', strtotime($booking->visit_date)) }}</p>
                    <div class="signature-area">{{ $booking->name }}</div>
                    <p>Pendaftar/Pelapor</p>
                </div>
            </div>
        </div>

        <div class="footer">
            <p>Halaman 3 dari 3</p>
            <p>Alamat: Kantor Sekretariat Wakil Presiden, Jalan Kebon Sirih No. 14, Jakarta Pusat</p>
            <p>Sekretariat Wakil Presiden Republik Indonesia</p>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Auto print when the page loads
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>

