<!-- resources/views/terms.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Syarat dan Ketentuan - Lapor Mas Wapress</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="{{ asset('css/styles.css') }}" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <span class="navbar-brand">Lapor Mas Wapres</span>
        </div>
    </nav>

    <div class="container text-center my-4">
        <img src="{{ asset('images/logo.png') }}" alt="Logo" height="120" class="img-fluid">
    </div>

    <div class="container py-3">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0 text-center">Tata Tertib Pelayanan Program Lapor Mas Wapres!</h4>
                    </div>
                    <div class="card-body">
                        <div class="terms-content mb-4">
                            <h5 class="fw-bold">KETENTUAN UMUM</h5>
                            <p>Pelayanan program Lapor Mas Wapres! diselenggarakan di Kantor Sekretariat Wakil Presiden, Jalan Kebon Sirih No. 14, Jakarta Pusat, pada hari kerja:</p>
                            <ul>
                                <li>Senin s.d. Kamis, pukul 08.00 s.d. 14.00 WIB (istirahat, pukul 12.00 s.d. 13.00 WIB)</li>
                                <li>Jumat, pukul 08.00 s.d. 14.30 WIB (istirahat, pukul 11.00 s.d. 13.30 WIB)</li>
                            </ul>
                            <ul>
                                <li>Pelapor memakai pakaian bebas rapi.</li>
                                <li>Pelapor wajib membawa kartu identitas (KTP/SIM/Identitas lain yang tercantum NIK).</li>
                                <li>Pengaduan yang dilayani berjumlah maksimal 50 orang/hari.</li>
                            </ul>

                            <h5 class="fw-bold mt-4">KETENTUAN PENGADUAN</h5>
                            <ul>
                                <li>Pelapor adalah orang yang langsung mengalami kejadian. Apabila pelapor bukan yang mengalami kejadian langsung, maka pelapor harus membawa surat kuasa bermaterai dari pihak yang diwakili.</li>
                                <li>Substansi aduan tidak sedang atau telah menjadi objek peradilan.</li>
                                <li>Substansi aduan belum pernah disampaikan oleh pelapor kepada Wakil Presiden.</li>
                                <li>Pelapor wajib membawa dokumen pendukung pengaduan yang lengkap dan relevan.</li>
                                <li>Petugas memverifikasi dokumen pengaduan. Apabila dokumen tidak lengkap, petugas akan meminta pelapor untuk mengirimkan kelengkapan dokumen melalui surel lapormaswapres@set.wapresri.go.id</li>
                                <li>Pelapor wajib menyampaikan nomor kontak atau surel yang dapat dihubungi.</li>
                            </ul>

                            <h5 class="fw-bold mt-4">REGISTRASI DAN PROSES PENGADUAN</h5>
                            <ul>
                                <li>Pelapor melakukan registrasi secara online melalui https://lapormaswapres.id</li>
                                <li>Pelapor yang telah berhasil melakukan registrasi online, harap hadir sesuai tanggal yang dipilih.</li>
                                <li>Pelapor menunggu di ruang tunggu yang telah disediakan.</li>
                                <li>Petugas memverifikasi dan memberikan nomor antrian pengaduan.</li>
                                <li>Petugas mempersilahkan pelapor ke Ruang Pengaduan berdasarkan nomor antrian.</li>
                            </ul>

                            <h5 class="fw-bold mt-4">HAL-HAL LAIN</h5>
                            <ul>
                                <li>Pelapor menghormati tata tertib yang berlaku, menjaga etika dan kesopanan selama berada di lingkungan Sekretariat Wakil Presiden.</li>
                                <li>Pelapor dilarang mengambil gambar/video dan membuat konten selama proses pelaporan.</li>
                                <li>Pelapor harus menaati seluruh ketentuan dalam Tata Tertib Lapor Mas Wapres! dan ketentuan lain yang ditetapkan di kemudian hari.</li>
                            </ul>
                        </div>
                        <div class="text-center">
                            <a href="{{ route('register.form') }}" class="btn btn-primary">Saya Setuju & Lanjutkan ke Pendaftaran</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>