<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Sekretariat Wakil Presiden</title>
        
        <!-- Bootstrap 5 CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
        <!-- Font Awesome for icons -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <!-- Google Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
        
        <style>
            :root {
                --blue-primary: #004B87;
                --blue-secondary: #176BAD;
                --blue-light: #E8F1F8;
                --red-accent: #D62828;
                --green-accent: #28A745;
                --neutral-dark: #333333;
                --neutral-light: #F5F7FA;
                --white: #FFFFFF;
                --shadow-sm: 0 2px 8px rgba(0, 0, 0, 0.08);
                --shadow-md: 0 4px 16px rgba(0, 0, 0, 0.1);
                --transition: all 0.3s ease;
            }
            
            body {
                font-family: 'Poppins', sans-serif;
                color: var(--neutral-dark);
                background-color: var(--neutral-light);
                line-height: 1.6;
            }
            
            /* Header Styles */
            .site-header {
                background-color: var(--white);
                box-shadow: var(--shadow-sm);
                position: sticky;
                top: 0;
                z-index: 100;
            }
            
            .logo-container {
                display: flex;
                align-items: center;
                gap: 15px;
            }
            
            .logo-text {
                font-size: 1rem;
                font-weight: 600;
                margin: 0;
                line-height: 1.2;
            }
            
            .logo-text small {
                font-weight: 400;
                font-size: 0.75rem;
                opacity: 0.8;
            }
            
            /* Content Styles */
            .page-title {
                color: var(--blue-primary);
                font-weight: 700;
                margin-bottom: 1.5rem;
                position: relative;
                display: inline-block;
            }
            
            .page-title::after {
                content: "";
                position: absolute;
                bottom: -8px;
                left: 0;
                width: 40%;
                height: 3px;
                background-color: var(--blue-secondary);
            }
            
            .service-option {
                position: relative;
                height: 100%;
                transition: var(--transition);
                border: none;
                background-color: var(--white);
                border-radius: 12px;
                overflow: hidden;
                box-shadow: var(--shadow-sm);
                text-decoration: none;
                color: inherit;
                display: block;
            }
            
            .service-option:hover {
                transform: translateY(-5px);
                box-shadow: var(--shadow-md);
            }
            
            .service-option-content {
                padding: 30px 20px;
                text-align: center;
            }
            
            .service-icon {
                width: 70px;
                height: 70px;
                border-radius: 50%;
                background-color: var(--blue-light);
                color: var(--blue-primary);
                display: flex;
                align-items: center;
                justify-content: center;
                margin: 0 auto 20px;
                font-size: 28px;
                transition: var(--transition);
            }
            
            .service-option:hover .service-icon {
                background-color: var(--blue-primary);
                color: var(--white);
            }
            
            .service-option h3 {
                font-size: 1.25rem;
                font-weight: 600;
                margin-bottom: 10px;
                color: var(--blue-primary);
            }
            
            .service-option p {
                font-size: 0.9rem;
                color: #666;
                margin-bottom: 0;
            }
            
            .service-option-footer {
                background-color: var(--blue-primary);
                color: var(--white);
                padding: 12px 15px;
                text-align: center;
                font-weight: 500;
                transition: var(--transition);
            }
            
            .service-option:hover .service-option-footer {
                background-color: var(--blue-secondary);
            }
            
            .service-option.danger .service-icon {
                background-color: #FFEBEE;
                color: var(--red-accent);
            }
            
            .service-option.danger:hover .service-icon {
                background-color: var(--red-accent);
                color: var(--white);
            }
            
            .service-option.danger .service-option-footer {
                background-color: var(--red-accent);
            }
            
            .service-option.success .service-icon {
                background-color: #E8F5E9;
                color: var(--green-accent);
            }
            
            .service-option.success:hover .service-icon {
                background-color: var(--green-accent);
                color: var (--white);
            }
            
            .service-option.success .service-option-footer {
                background-color: var(--green-accent);
            }
            
            /* Social Media Styles */
            .social-section {
                background-color: var(--white);
                border-radius: 12px;
                padding: 2rem;
                box-shadow: var(--shadow-sm);
            }
            
            .social-title {
                font-size: 1.25rem;
                font-weight: 600;
                color: var(--blue-primary);
                margin-bottom: 1.5rem;
                text-align: center;
            }
            
            .social-link {
                display: flex;
                align-items: center;
                justify-content: center;
                width: 45px;
                height: 45px;
                border-radius: 8px;
                background-color: var(--blue-light);
                color: var(--blue-primary);
                transition: var(--transition);
                margin: 0 8px;
            }
            
            .social-link:hover {
                transform: translateY(-3px);
            }
            
            .social-link.facebook:hover {
                background-color: #3b5998;
                color: var(--white);
            }
            
            .social-link.instagram:hover {
                background-color: #e1306c;
                color: var(--white);
            }
            
            .social-link.youtube:hover {
                background-color: #ff0000;
                color: var(--white);
            }
            
            .social-link.website:hover {
                background-color: #00a1ff;
                color: var(--white);
            }
            
            /* Footer Styles */
            .site-footer {
                background-color: var(--blue-primary);
                color: var(--white);
                padding: 1.5rem 0;
            }
            
            .copyright {
                font-size: 0.875rem;
                margin-bottom: 0;
            }
            
            /* Responsive Adjustments */
            @media (max-width: 767.98px) {
                .page-title {
                    font-size: 1.75rem;
                }
                
                .page-title::after {
                    width: 60px;
                }
                
                .service-option-content {
                    padding: 20px 15px;
                }
                
                .service-icon {
                    width: 60px;
                    height: 60px;
                    font-size: 24px;
                }
                
                .social-section {
                    padding: 1.5rem;
                }
            }
        </style>
    </head>
    <body>
        <header class="site-header py-3">
            <div class="container">
                <div class="logo-container">
                    <img src="{{ asset('images/logo.png') }}" alt="Logo Wakil Presiden RI" height="50">
                    <div>
                        <h1 class="logo-text">Sekretariat Wakil Presiden</h1>
                        <p class="logo-text"><small>Republik Indonesia</small></p>
                    </div>
                </div>
            </div>
        </header>

        <main class="py-5">
            <div class="container">
                <div class="row justify-content-center mb-5">
                    <div class="col-lg-10">
                        <h2 class="page-title text-center">Sampaikan Laporan Anda</h2>
                        <p class="text-center text-muted mb-5">Pilih kanal pengaduan sesuai kebutuhan Anda</p>
                        
                        <div class="row g-4 mb-5">
                            <!-- Tatap Muka -->
                            <div class="col-md-4">
                                <a href="{{ route('terms') }}" class="service-option">
                                    <div class="service-option-content">
                                        <div class="service-icon">
                                            <i class="fas fa-users"></i>
                                        </div>
                                        <h3>Tatap Muka</h3>
                                        <p>Registrasi untuk pertemuan tatap muka langsung dengan perwakilan kami</p>
                                    </div>
                                    <div class="service-option-footer">
                                        <i class="fas fa-arrow-right me-2"></i> Daftar Sekarang
                                    </div>
                                </a>
                            </div>
                            
                            <!-- WhatsApp -->
                            <div class="col-md-4">
                                <a href="https://wa.me/6281117042204" target="_blank" class="service-option success">
                                    <div class="service-option-content">
                                        <div class="service-icon">
                                            <i class="fab fa-whatsapp"></i>
                                        </div>
                                        <h3>WhatsApp</h3>
                                        <p>Hubungi kami melalui WhatsApp untuk informasi atau pertanyaan</p>
                                    </div>
                                    <div class="service-option-footer">
                                        <i class="fas fa-arrow-right me-2"></i> Hubungi
                                    </div>
                                </a>
                            </div>
                            <!-- Pengaduan Online -->
                            <div class="col-md-4">
                                <a href="https://lapor.go.id/" target="_blank" class="service-option danger">
                                    <div class="service-option-content">
                                        <div class="service-icon">
                                            <i class="fas fa-bullhorn"></i>
                                        </div>
                                        <h3>Pengaduan Online</h3>
                                        <p>Sampaikan laporan atau aduan Anda melalui sistem LAPOR!</p>
                                    </div>
                                    <div class="service-option-footer">
                                        <i class="fas fa-arrow-right me-2"></i> Laporkan
                                    </div>
                                </a>
                            </div>
                    
                        </div>
                        
                        <!-- Social Media -->
                        <div class="social-section">
                            <h4 class="social-title">Ikuti Kami</h4>
                            <div class="d-flex justify-content-center">
                                <!-- Website -->
                                <a href="https://www.wapresri.go.id/" target="_blank" class="social-link website">
                                    <i class="fas fa-globe"></i>
                                </a>
                                
                                <!-- Facebook -->
                                <a href="https://www.facebook.com/wapresri.go.id" target="_blank" class="social-link facebook">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                                
                                <!-- Instagram -->
                                <a href="https://www.instagram.com/setwapres.ri/" target="_blank" class="social-link instagram">
                                    <i class="fab fa-instagram"></i>
                                </a>
                                
                                <!-- YouTube -->
                                <a href="https://www.youtube.com/@Setwapres" target="_blank" class="social-link youtube">
                                    <i class="fab fa-youtube"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
        
        <footer class="site-footer">
            <div class="container text-center">
                <p class="copyright">Copyright © 2025 IT Setwapres | All Rights Reserved.</p>
            </div>
        </footer>
        
        <!-- Bootstrap JS Bundle -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    </body>
</html>
