import defaultTheme from 'tailwindcss/defaultTheme';

/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    "./resources/**/*.blade.php",
    "./resources/**/*.js",
    "./resources/**/*.vue",
  ],
  theme: {
    extend: {
      fontFamily: {
        sans: ['Figtree', ...defaultTheme.fontFamily.sans],
      },
      colors: {
        primary: {
          50: '#f0f9ff',
          100: '#e0f2fe',
          500: '#4f46e5',
          600: '#4338ca',
          700: '#3730a3',
        }
      },
      boxShadow: {
        '3xl': '0 35px 60px -15px rgba(0, 0, 0, 0.3)',
      },
      maxWidth: {
        '6xl': '72rem', // Wider container
      },
      padding: {
        '18': '4.5rem', // Additional padding option
      },
      spacing: {
        '18': '4.5rem',
      }
    },
  },
  plugins: [
    require('@tailwindcss/forms')
  ],
}
