<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Holiday;

class SettingController extends Controller
{
    public function edit()
    {
        $settings = Setting::all();
        $holidays = Holiday::orderBy('date')->get();
        return view('admin.settings', compact('settings', 'holidays'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'quota_08_00' => 'required|integer|min:0',
            'quota_09_00' => 'required|integer|min:0',
            'quota_10_00' => 'required|integer|min:0',
            'quota_11_00' => 'required|integer|min:0'
        ]);

        $quotas = [
            'quota_08_00' => $request->quota_08_00,
            'quota_09_00' => $request->quota_09_00,
            'quota_10_00' => $request->quota_10_00,
            'quota_11_00' => $request->quota_11_00
        ];

        foreach ($quotas as $key => $value) {
            Setting::updateOrCreate(
                ['key' => $key],
                ['value' => $value]
            );
        }

        return redirect()
            ->route('admin.settings')
            ->with('success', 'Pengaturan kuota berhasil diperbarui');
    }
}
