<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Carbon\Carbon;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        $this->publishes([
            base_path('resources/css') => public_path('css'),
        ], 'public');

        // Set default timezone
        date_default_timezone_set('Asia/Jakarta');
        
        // Set Carbon locale
        Carbon::setLocale('id');
    }
}
