<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('registrations', function (Blueprint $table) {
            $table->id();
            $table->string('booking_code');
            $table->string('name');
            $table->string('nik', 16);
            $table->string('phone');
            $table->string('email')->nullable();
            $table->string('topic')->nullable();
            $table->boolean('priority')->default(false);   
            $table->string('pendamping')->nullable();
            $table->string('ktp_image')->nullable();
            $table->date('visit_date');
            $table->string('visit_time');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('registrations');
    }
};
