<!-- resources/views/admin/dashboard.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="{{ asset('css/styles.css') }}" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-light">
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary mb-4">
        <div class="container">
            <a class="navbar-brand" href="#">
                <img src="{{ asset('images/logo.png') }}" alt="Logo" height="30" class="d-inline-block align-text-top me-2">
                Admin Dashboard
            </a>
            <div class="d-flex">
                <a href="{{ route('admin.reports') }}" class="btn btn-light me-2">
                    <i class="bi bi-file-text"></i> Reports
                </a>
                <a href="{{ route('admin.settings') }}" class="btn btn-light me-2">
                    <i class="bi bi-gear-fill"></i> Settings
                </a>
                <form action="{{ route('admin.logout') }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-light">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </button>
                </form>
            </div>
        </div>
    </nav>

    <div class="container main-content">
        <div class="row">
            <div class="col-md-6">
                <div class="stat-card">
                    <h5>
                        <i class="bi bi-people me-2"></i>
                        Pendaftaran Hari Ini
                    </h5>
                    <p>{{ $registrationsToday }}</p>
                    <div class="icon">
                        <i class="bi bi-calendar-check"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="stat-card">
                    <h5>
                        <i class="bi bi-graph-up me-2"></i>
                        Total Pendaftaran Bulan Ini
                    </h5>
                    <p>{{ $totalRegistrationsThisMonth }}</p>
                    <div class="icon">
                        <i class="bi bi-calendar-month"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">Daftar Pendaftar Hari Ini</h5>
                        <form action="{{ route('admin.dashboard') }}" method="GET" class="mt-2">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="Cari nama/NIK..." name="search" value="{{ $search }}">
                                <button class="btn btn-primary" type="submit">
                                    <i class="bi bi-search"></i> Cari
                                </button>
                            </div>
                        </form>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama</th>
                                        <th>NIK</th>
                                        <th>No. Telp</th>
                                        <th>Topik Aduan</th>
                                        <th>Status</th>
                                        <th>Pendamping</th>
                                        <th>Waktu Kunjungan</th>
                                        <th>Kode Booking</th>
                                        <th>KTP</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($todayRegistrations as $registration)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $registration->name }}</td>
                                        <td>{{ $registration->nik }}</td>
                                        <td>{{ $registration->phone }}</td>
                                        <td>{{ $registration->topic }}</td>
                                        <td>
                                            @if($registration->priority)
                                                <span class="badge bg-info">Kelompok Rentan/Difabel</span>
                                            @else
                                                <span class="badge bg-secondary">Reguler</span>
                                            @endif
                                        </td>
                                        <td>{{ $registration->pendamping ?: '-' }}</td>
                                        <td>{{ $registration->visit_time }}</td>
                                        <td>{{ $registration->booking_code }}</td>
                                        <td>
                                            @if($registration->ktp_image)
                                                <div class="btn-group">
                                                    <a href="{{ route('admin.serve.ktp', $registration) }}" 
                                                       class="btn btn-sm btn-info" 
                                                       target="_blank"
                                                       title="Lihat KTP">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                    <a href="{{ route('admin.download.ktp', $registration) }}" 
                                                       class="btn btn-sm btn-success"
                                                       title="Download KTP">
                                                        <i class="bi bi-download"></i>
                                                    </a>
                                                </div>
                                            @else
                                                <span class="badge bg-warning">Tidak ada KTP</span>
                                            @endif
                                        </td>

                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="10" class="text-center">Tidak ada pendaftar hari ini</td>
                                    </tr>
                                    @endforelse

                                </tbody>
                            </table>
                            <div class="d-flex justify-content-center mt-4">
    {{ $todayRegistrations->links('pagination::bootstrap-5') }}
</div>    
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer">
        <p class="text-center">&copy; Admin Dashboard</p>
    </div>
</body>
</html>
