<!-- resources/views/admin/reports.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reports - Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="{{ asset('css/styles.css') }}" rel="stylesheet">
</head>
<body class="bg-light">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary mb-4">
        <div class="container">
            <a class="navbar-brand" href="{{ route('admin.dashboard') }}">
                <i class="bi bi-arrow-left me-2"></i>
                Kembali ke Dashboard
            </a>
        </div>
    </nav>

    <div class="container">
        <div class="card shadow-sm">
            <div class="card-body">
                <h4 class="card-title mb-4">
                    <i class="bi bi-file-text me-2"></i>
                    Laporan Pendaftaran
                </h4>

                <!-- Search and Filter Form -->
                <form action="{{ route('admin.reports') }}" method="GET" class="row g-3 mb-4">
                    <div class="col-md-3">
                        <label class="form-label">Tanggal Mulai</label>
                        <input type="date" 
                               name="start_date" 
                               class="form-control"
                               value="{{ request('start_date') }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Tanggal Akhir</label>
                        <input type="date" 
                               name="end_date" 
                               class="form-control"
                               value="{{ request('end_date') }}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Cari</label>
                        <input type="text" 
                               name="search" 
                               class="form-control"
                               placeholder="Cari nama/NIK/kode booking..."
                               value="{{ request('search') }}">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-search me-2"></i>Cari
                            </button>
                        </div>
                    </div>
                </form>

                <!-- Export Button -->
                <form action="{{ route('admin.reports.export') }}" method="POST" class="mb-4">
                    @csrf
                    <input type="hidden" name="start_date" value="{{ request('start_date') }}">
                    <input type="hidden" name="end_date" value="{{ request('end_date') }}">
                    <input type="hidden" name="search" value="{{ request('search') }}">
                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-file-excel me-2"></i>Export ke Excel
                    </button>
                </form>

                <!-- Registrations Table -->
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                            <th>No</th>
                            <th>Kode Booking</th>
                            <th>Nama</th>
                            <th>NIK</th>
                            <th>No. Telp</th>
                            <th>Email</th>
                        <th>Topik Aduan</th>
                <th>Status</th>
                <th>Pendamping</th>
                <th>Tanggal</th>
                <th>Jam</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($registrations as $registration)
                            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $registration->booking_code }}</td>
                <td>{{ $registration->name }}</td>
                <td>{{ $registration->nik }}</td>
                <td>{{ $registration->phone }}</td>
                <td>{{ $registration->email ?: '-' }}</td>
                <td>{{ $registration->topic }}</td>
                <td>
                    @if($registration->priority)
                        <span class="badge bg-info">Kelompok Rentan/Difabel</span>
                    @else
                        <span class="badge bg-secondary">Reguler</span>
                    @endif
                </td>
                <td>{{ $registration->pendamping ?: '-' }}</td>
                <td>{{ \Carbon\Carbon::parse($registration->visit_date)->format('d/m/Y') }}</td>
                <td>{{ $registration->visit_time }}</td>
            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="text-center">Tidak ada data</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    {{ $registrations->appends(request()->query())->links() }}
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>