<!-- resources/views/register.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrasi - Lapor Mas Wapres</title>
    <link href="{{ asset('css/lib/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('css/lib/bootstrap-icons.css') }}" rel="stylesheet">
    <link href="{{ asset('css/styles.css') }}" rel="stylesheet">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <script src="{{ asset('js/lib/jquery-3.6.0.min.js') }}"></script>
    <script src="{{ asset('js/lib/moment.min.js') }}"></script>
    <script src="{{ asset('js/lib/moment-timezone.min.js') }}"></script>
    <script src="{{ asset('js/datepicker.js') }}" defer></script>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <span class="navbar-brand">Lapor Mas Wapres</span>
        </div>
    </nav>

    <div class="container text-center my-4">
        <img src="{{ asset('images/logo.png') }}" alt="Logo" height="120" class="img-fluid">
    </div>

    <div class="container py-3">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0 text-center">Formulir Registrasi Lapor Mas Wapres</h4>
                    </div>
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form action="{{ route('register.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                                <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Jenis Kelamin <span class="text-danger">*</span></label>
                                <div class="d-flex gap-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="gender" id="genderL" value="L" {{ old('gender') == 'L' ? 'checked' : '' }} required>
                                        <label class="form-check-label" for="genderL">
                                            Laki-laki
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="gender" id="genderP" value="P" {{ old('gender') == 'P' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="genderP">
                                            Perempuan
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Nomor KTP <span class="text-danger">*</span></label>
                                <input type="text" name="nik" class="form-control" pattern="[0-9]{16}" maxlength="16" value="{{ old('nik') }}" required>
                                <small class="text-muted">Harus 16 digit angka</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Nomor KK <span class="text-danger">*</span></label>
                                <input type="text" name="no_kk" class="form-control" pattern="[0-9]{16}" maxlength="16" value="{{ old('no_kk') }}" required>
                                <small class="text-muted">Harus 16 digit angka</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">No. Telepon <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text" name="phone" class="form-control" 
                                           pattern="^62\d+" 
                                           value="{{ old('phone') }}" 
                                           placeholder="628123456789"
                                           required>
                                </div>
                                <small class="text-muted">Format: 62 diikuti nomor telepon (contoh: 628123456789)</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" 
                                       name="email" 
                                       class="form-control @error('email') is-invalid @enderror" 
                                       value="{{ old('email') }}">
                                <small class="text-muted">Masukkan alamat email (opsional)</small>
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Topik Aduan <span class="text-danger">*</span></label>
                                <input type="text" 
                                       name="topic" 
                                       class="form-control @error('topic') is-invalid @enderror" 
                                       value="{{ old('topic') }}" 
                                       required>
                                @error('topic')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <div class="form-check">
                                    <input type="checkbox" 
                                           class="form-check-input" 
                                           id="priority" 
                                           name="priority" 
                                           value="1" 
                                           {{ old('priority') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="priority">
                                        Saya adalah Kelompok Rentan/Difabel yang membutuhkan Pendamping
                                    </label>
                                </div>
                            </div>

                            <div class="mb-3" id="pendampingField" style="display: none;">
                                <label class="form-label">Nama Pendamping</label>
                                <input type="text" 
                                       name="pendamping" 
                                       class="form-control @error('pendamping') is-invalid @enderror" 
                                       value="{{ old('pendamping') }}">
                                @error('pendamping')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Masukan Foto KTP anda <span class="text-danger">*</span></label>
                                <input type="file" name="ktp_image" class="form-control @error('ktp_image') is-invalid @enderror" accept="image/*" capture="camera" required>
                                @error('ktp_image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="row">
                                <!-- Date Picker Column -->
                                <div class="col-md-6">
                                    <div class="mb-4">
                                        <label class="form-label fw-bold">Tanggal Kunjungan <span class="text-danger">*</span></label>
                                        <input type="hidden" name="visit_date" id="selected_date" value="{{ old('visit_date') }}" required>
                                        
                                        <div class="date-picker-container">
                                            <div class="date-picker-header">
                                                <button type="button" class="month-nav" id="prevMonth">
                                                    <i class="bi bi-chevron-left"></i>
                                                </button>
                                                <div id="currentMonth"></div>
                                                <button type="button" class="month-nav" id="nextMonth">
                                                    <i class="bi bi-chevron-right"></i>
                                                </button>
                                            </div>
                                            
                                            <div class="calendar-grid">
                                                <div class="weekday-header">Min</div>
                                                <div class="weekday-header">Sen</div>
                                                <div class="weekday-header">Sel</div>
                                                <div class="weekday-header">Rab</div>
                                                <div class="weekday-header">Kam</div>
                                                <div class="weekday-header">Jum</div>
                                                <div class="weekday-header">Sab</div>
                                            </div>
                                            
                                            <div class="calendar-grid" id="calendarDays"></div>
                                            
                                            <div class="date-info">
                                                <div class="selected-date" id="selectedDateText">
                                                    Pilih tanggal kunjungan
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Time Slots Column -->
                                <div class="col-md-6">
                                    <div class="mb-4">
                                        <label class="form-label fw-bold">Jam Kunjungan <span class="text-danger">*</span></label>
                                        <div class="d-flex flex-column gap-3">
                                            <div class="w-100">
                                                <input type="radio" class="btn-check" name="visit_time" id="time_08_00" value="08:00" {{ old('visit_time') == '08:00' ? 'checked' : '' }} required>
                                                <label class="btn btn-outline-primary w-100 time-slot-card" for="time_08_00">
                                                    <div class="d-flex align-items-center">
                                                        <i class="bi bi-sun fs-4 me-3"></i>
                                                        <div>
                                                            <h5 class="mb-0">08:00</h5>
                                                            <small class="text-muted">Pagi</small>
                                                        </div>
                                                        <div class="quota-info ms-auto">
                                                            <small class="text-muted">Kuota Tersedia</small>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>

                                            <div class="w-100">
                                                <input type="radio" class="btn-check" name="visit_time" id="time_09_00" value="09:00" {{ old('visit_time') == '09:00' ? 'checked' : '' }} required>
                                                <label class="btn btn-outline-primary w-100 time-slot-card" for="time_09_00">
                                                    <div class="d-flex align-items-center">
                                                        <i class="bi bi-sun fs-4 me-3"></i>
                                                        <div>
                                                            <h5 class="mb-0">09:00</h5>
                                                            <small class="text-muted">Pagi</small>
                                                        </div>
                                                        <div class="quota-info ms-auto">
                                                            <small class="text-muted">Kuota Tersedia</small>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>

                                            <div class="w-100">
                                                <input type="radio" class="btn-check" name="visit_time" id="time_10_00" value="10:00" {{ old('visit_time') == '10:00' ? 'checked' : '' }} required>
                                                <label class="btn btn-outline-primary w-100 time-slot-card" for="time_10_00">
                                                    <div class="d-flex align-items-center">
                                                        <i class="bi bi-sun fs-4 me-3"></i>
                                                        <div>
                                                            <h5 class="mb-0">10:00</h5>
                                                            <small class="text-muted">Pagi</small>
                                                        </div>
                                                        <div class="quota-info ms-auto">
                                                            <small class="text-muted">Kuota Tersedia</small>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>

                                            <div class="w-100">
                                                <input type="radio" class="btn-check" name="visit_time" id="time_11_00" value="11:00" {{ old('visit_time') == '11:00' ? 'checked' : '' }} required>
                                                <label class="btn btn-outline-primary w-100 time-slot-card" for="time_11_00">
                                                    <div class="d-flex align-items-center">
                                                        <i class="bi bi-sun fs-4 me-3"></i>
                                                        <div>
                                                            <h5 class="mb-0">11:00</h5>
                                                            <small class="text-muted">Siang</small>
                                                        </div>
                                                        <div class="quota-info ms-auto">
                                                            <small class="text-muted">Kuota Tersedia</small>
                                                        </div>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mb-4">
                                <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"></div>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Daftar Sekarang</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const priorityCheck = document.getElementById('priority');
        const pendampingField = document.getElementById('pendampingField');

        function togglePendamping() {
            pendampingField.style.display = priorityCheck.checked ? 'block' : 'none';
        }

        priorityCheck.addEventListener('change', togglePendamping);
        togglePendamping(); // Initial state
    });
    </script>
</body>
</html>