<?php
// routes/web.php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RegistrationController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\SettingController;

// Public Routes
Route::get('/', [RegistrationController::class, 'terms'])->name('terms');
Route::get('/register', [RegistrationController::class, 'showForm'])->name('register.form');
Route::post('/register', [RegistrationController::class, 'store'])->name('register.store');
Route::get('/check-quota/{date}/{time}', [RegistrationController::class, 'checkQuota'])
    ->name('check.quota')
    ->where([
        'date' => '[0-9]{4}-[0-9]{2}-[0-9]{2}',
        'time' => '[0-9]{2}:[0-9]{2}'
    ]);

// Admin Routes
Route::get('/admin', [AdminController::class, 'loginForm'])->name('admin.login');
Route::get('/admin/login', [AdminController::class, 'loginForm'])->name('admin.login');
Route::post('/admin/login', [AdminController::class, 'login'])->name('admin.login.post');
Route::post('/admin/logout', [AdminController::class, 'logout'])->name('admin.logout');

// Protected Admin Routes
Route::middleware(['auth:admin'])->group(function () {
    Route::get('/admin/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/admin/registrations', [AdminController::class, 'registrations'])->name('admin.registrations');
    
    // Settings Routes
    Route::get('/admin/settings', [SettingController::class, 'edit'])->name('admin.settings');
    Route::post('/admin/settings/update', [SettingController::class, 'update'])->name('admin.settings.update');
    
    Route::get('/admin/reports', [AdminController::class, 'reports'])->name('admin.reports');
    Route::post('/admin/reports/export', [AdminController::class, 'exportReport'])->name('admin.reports.export');
    Route::post('/admin/holiday', [AdminController::class, 'storeHoliday'])->name('admin.holiday.store');
    Route::delete('/admin/holiday/{id}', [AdminController::class, 'deleteHoliday'])->name('admin.holiday.delete');
    Route::get('/admin/ktp/{registration}/view', [AdminController::class, 'serveKtpImage'])
        ->name('admin.serve.ktp');
    Route::get('/admin/ktp/{registration}/download', [AdminController::class, 'downloadKtp'])
        ->name('admin.download.ktp');
});
