<!-- resources/views/booking-confirmation.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Confirmation - Lapor Mas Wapres</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('css/styles.css')); ?>" rel="stylesheet">
    <style>
        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center">
                <img src="<?php echo e(asset('images/logo.png')); ?>" alt="Logo" height="40" class="me-2">
                <!-- Page specific title -->
            </a>
            <!-- Rest of navbar content -->
        </div>
    </nav>
    <div class="container py-5" id="printArea">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-success text-white">
                        <h4 class="mb-0 text-center">Registrasi Berhasil!</h4>
                    </div>
                    <div class="card-body text-center">
                        <div class="mb-4">
                            <h5>Kode Booking Anda:</h5>
                            <h2 class="text-primary"><?php echo e($booking->booking_code); ?></h2>
                            <div class="qr-code my-3">
                                <?php echo QrCode::size(200)->generate($booking->booking_code); ?>

                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <h5 class="mb-3">Detail Registrasi:</h5>
                            <table class="table table-bordered">
                                <tbody>
                                    <tr>
                                        <th class="bg-light text-start" width="30%">Nama</th>
                                        <td class="text-start"><?php echo e($booking->name); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="bg-light text-start">NIK</th>
                                        <td class="text-start"><?php echo e($booking->nik); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="bg-light text-start">Email</th>
                                        <td class="text-start"><?php echo e($booking->email); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="bg-light text-start">No. Telepon</th>
                                        <td class="text-start"><?php echo e($booking->phone); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="bg-light text-start">Topik Aduan</th>
                                        <td class="text-start"><?php echo e($booking->topic); ?></td>
                                    </tr>
                                    <?php if($booking->priority): ?>
                                    <tr>
                                        <th class="bg-light text-start">Status</th>
                                        <td class="text-start">
                                            <span class="badge bg-info">Kelompok Rentan/Difabel</span>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                    <?php if($booking->pendamping): ?>
                                    <tr>
                                        <th class="bg-light text-start">Nama Pendamping</th>
                                        <td class="text-start"><?php echo e($booking->pendamping); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <th class="bg-light text-start">Tanggal Kunjungan</th>
                                        <td class="text-start"><?php echo e(date('d/m/Y', strtotime($booking->visit_date))); ?></td>
                                    </tr>
                                    <tr>
                                        <th class="bg-light text-start">Jam Kunjungan</th>
                                        <td class="text-start"><?php echo e($booking->visit_time); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <div class="alert alert-warning">
                            <strong>Penting!</strong><br>
                            Simpan kode booking ini dan tunjukkan saat kunjungan.
                        </div>

                        <div class="btn-group no-print">
                            <button onclick="window.print()" class="btn btn-success">
                                <i class="bi bi-printer"></i> Cetak
                            </button>
                            <a href="<?php echo e(route('terms')); ?>" class="btn btn-secondary">
                                Kembali ke Halaman Utama
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH D:\Koding\lapor-mas-wapress -V1.1\resources\views/booking-confirmation.blade.php ENDPATH**/ ?>