<!-- resources/views/admin/reports.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reports - Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="<?php echo e(asset('css/styles.css')); ?>" rel="stylesheet">
</head>
<body class="bg-light">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary mb-4">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('admin.dashboard')); ?>">
                <i class="bi bi-arrow-left me-2"></i>
                Kembali ke Dashboard
            </a>
        </div>
    </nav>

    <div class="container">
        <div class="card shadow-sm">
            <div class="card-body">
                <h4 class="card-title mb-4">
                    <i class="bi bi-file-text me-2"></i>
                    Laporan Pendaftaran
                </h4>

                <!-- Search and Filter Form -->
                <form action="<?php echo e(route('admin.reports')); ?>" method="GET" class="row g-3 mb-4">
                    <div class="col-md-3">
                        <label class="form-label">Tanggal Mulai</label>
                        <input type="date" 
                               name="start_date" 
                               class="form-control"
                               value="<?php echo e(request('start_date')); ?>">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Tanggal Akhir</label>
                        <input type="date" 
                               name="end_date" 
                               class="form-control"
                               value="<?php echo e(request('end_date')); ?>">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Cari</label>
                        <input type="text" 
                               name="search" 
                               class="form-control"
                               placeholder="Cari nama/NIK/kode booking..."
                               value="<?php echo e(request('search')); ?>">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-search me-2"></i>Cari
                            </button>
                        </div>
                    </div>
                </form>

                <!-- Export Button -->
                <form action="<?php echo e(route('admin.reports.export')); ?>" method="POST" class="mb-4">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="start_date" value="<?php echo e(request('start_date')); ?>">
                    <input type="hidden" name="end_date" value="<?php echo e(request('end_date')); ?>">
                    <input type="hidden" name="search" value="<?php echo e(request('search')); ?>">
                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-file-excel me-2"></i>Export ke Excel
                    </button>
                </form>

                <!-- Registrations Table -->
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                            <th>No</th>
                            <th>Kode Booking</th>
                            <th>Nama</th>
                            <th>NIK</th>
                            <th>No. Telp</th>
                            <th>Email</th>
                        <th>Topik Aduan</th>
                <th>Status</th>
                <th>Pendamping</th>
                <th>Tanggal</th>
                <th>Jam</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $registrations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $registration): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                <td><?php echo e($loop->iteration); ?></td>
                <td><?php echo e($registration->booking_code); ?></td>
                <td><?php echo e($registration->name); ?></td>
                <td><?php echo e($registration->nik); ?></td>
                <td><?php echo e($registration->phone); ?></td>
                <td><?php echo e($registration->email ?: '-'); ?></td>
                <td><?php echo e($registration->topic); ?></td>
                <td>
                    <?php if($registration->priority): ?>
                        <span class="badge bg-info">Kelompok Rentan/Difabel</span>
                    <?php else: ?>
                        <span class="badge bg-secondary">Reguler</span>
                    <?php endif; ?>
                </td>
                <td><?php echo e($registration->pendamping ?: '-'); ?></td>
                <td><?php echo e(\Carbon\Carbon::parse($registration->visit_date)->format('d/m/Y')); ?></td>
                <td><?php echo e($registration->visit_time); ?></td>
            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center">Tidak ada data</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($registrations->appends(request()->query())->links()); ?>

                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH D:\Koding\lapor-mas-wapress -V1.1\resources\views\admin\reports.blade.php ENDPATH**/ ?>